/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.injector;

import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionStep;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeInjector {
    private final BiomeInjectionRules rules;

    public BiomeInjector(ChunkSource chunkSource, BiomeSource biomeSource, BiomeInjectionRules rules) {
        this.rules = rules;
    }

    public void injectBiomes(Biome[] biomes, ChunkPrimer chunkPrimer, ChunkSource chunkSource, int chunkX, int chunkZ, BiomeInjectionStep step) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        BiomeInjectionRules.BiomeInjectionContext context = new BiomeInjectionRules.BiomeInjectionContext();
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int x = localX + startX;
                int z = localZ + startZ;
                int ndx = localX + localZ * 16;
                int height = MathHelper.func_76125_a((int)chunkSource.getHeight(x, z, HeightmapChunk.Type.SURFACE), (int)0, (int)255);
                int heightAbove = MathHelper.func_76125_a((int)(chunkSource.getHeight(x, z, HeightmapChunk.Type.SURFACE) + 1), (int)0, (int)255);
                context.setPos(x, height, z);
                context.setState(chunkPrimer.func_177856_a(localX, height, localZ));
                context.setStateAbove(chunkPrimer.func_177856_a(localX, heightAbove, localZ));
                context.setBiome(biomes[ndx]);
                Biome injectedBiome = this.getInjectedBiome(context, x, z, step);
                if (injectedBiome == null) continue;
                biomes[ndx] = injectedBiome;
            }
        }
    }

    public Biome getInjectedBiome(BiomeInjectionRules.BiomeInjectionContext context, int x, int z, BiomeInjectionStep step) {
        return this.rules.test(context, x, z, step);
    }

    public boolean hasNoRules() {
        return this.rules.isEmpty();
    }

    public static boolean atBeachDepth(int topHeight, int seaLevel) {
        return topHeight >= seaLevel - 4 && topHeight <= seaLevel + 1;
    }

    public static boolean isBeachBlock(IBlockState blockState, Biome biome) {
        Block block = blockState.func_177230_c();
        return block == (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) ? Blocks.field_150425_aM : Blocks.field_150354_m);
    }

    public static boolean atOceanDepth(int topHeight, int oceanDepth, int seaLevel) {
        return topHeight < seaLevel - oceanDepth;
    }

    public static boolean isFluidBlock(IBlockState blockState, IBlockState defaultFluid) {
        return blockState.func_177230_c() == defaultFluid.func_177230_c();
    }
}

