/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.chunk;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.util.DebugUtil;
import mod.bespectacled.modernbetaforge.util.ObjectPool;
import mod.bespectacled.modernbetaforge.util.chunk.ChunkCache;
import mod.bespectacled.modernbetaforge.util.chunk.ComponentChunk;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeDecorator;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeMobs;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionStep;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjector;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBetaCave;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.structure.ModernBetaStructures;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ModernBetaChunkGenerator
extends ChunkGeneratorOverworld {
    public static final ResourceLocation CAVE_KEY = new ResourceLocation("cave");
    public static final ResourceLocation RAVINE_KEY = new ResourceLocation("ravine");
    public static final ResourceLocation CAVE_WATER_KEY = ModernBeta.createRegistryKey("cave_water");
    private static final int INITIAL_CHUNK_CAPACITY = 256;
    private static final int MAX_RENDER_DISTANCE_AREA = 1024;
    private final World world;
    private final Random random;
    private final ChunkSource chunkSource;
    private final ModernBetaGeneratorSettings settings;
    private final ObjectPool<ChunkPrimer> primerPool;
    private final ModernBetaBiomeProvider biomeProvider;
    private final BiomeInjector biomeInjector;
    private final ChunkCache<ChunkPrimerContainer> initialChunkCache;
    private final ChunkCache<ComponentChunk> componentCache;
    private final Map<ResourceLocation, MapGenStructure> structures;
    private final Map<ResourceLocation, MapGenBase> carvers;

    public ModernBetaChunkGenerator(World world, String generatorOptions) {
        super(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), generatorOptions);
        ModernBetaGeneratorSettings settings = generatorOptions != null ? ModernBetaGeneratorSettings.build(generatorOptions) : ModernBetaGeneratorSettings.build();
        this.world = world;
        this.random = new Random(world.func_72905_C());
        this.chunkSource = ModernBetaRegistries.CHUNK_SOURCE.get(settings.chunkSource).apply(world.func_72905_C(), settings);
        this.settings = settings;
        this.primerPool = new ObjectPool<ChunkPrimer>(ChunkPrimer::new, chunkPrimer -> {});
        this.biomeProvider = (ModernBetaBiomeProvider)world.func_72959_q();
        this.biomeProvider.setChunkGenerator(this);
        this.biomeInjector = new BiomeInjector(this.chunkSource, this.biomeProvider.getBiomeSource(), this.chunkSource.buildBiomeInjectorRules(this.biomeProvider.getBiomeSource()));
        this.initialChunkCache = new ChunkCache<ChunkPrimerContainer>("initial_chunk", 256, this::provideInitialChunk);
        this.componentCache = new ChunkCache<ComponentChunk>("components", 1024, ComponentChunk::new);
        this.structures = this.initStructures(settings, world.func_72912_H().func_76089_r());
        this.carvers = ModernBetaRegistries.CARVER.getEntrySet().stream().collect(Collectors.toMap(e -> (ResourceLocation)e.getKey(), e -> ((ModernBetaRegistries.CarverCreator)e.getValue()).apply(this.chunkSource, this.settings)));
        world.func_181544_b(this.chunkSource.getSeaLevel());
        if (this.chunkSource instanceof FiniteChunkSource) {
            FiniteChunkSource finiteChunkSource = (FiniteChunkSource)this.chunkSource;
            finiteChunkSource.setLevelNotifier(message -> {
                if (world.func_73046_m() != null) {
                    world.func_73046_m().func_71192_d(message + "..");
                }
            });
            finiteChunkSource.loadOrCreateLevelDataContainer(this.world);
            if (!finiteChunkSource.hasPregenerated()) {
                finiteChunkSource.pregenerateTerrainOrWait();
                finiteChunkSource.saveLevelDataContainer(this.world);
            }
        }
        DebugUtil.resetDebug("modernbeta.generateChunk");
    }

    public void func_185976_a(int chunkX, int chunkZ, ChunkPrimer chunkPrimer) {
        ChunkPrimerContainer chunkContainer = this.initialChunkCache.get(chunkX, chunkZ);
        ChunkPrimer containerPrimer = chunkContainer.chunkPrimer;
        if (this.structures.containsKey(ModernBetaStructures.VILLAGE)) {
            this.structures.get(ModernBetaStructures.VILLAGE).func_186125_a(this.world, chunkX, chunkZ, containerPrimer);
        }
        List<StructureComponent> structureComponents = this.componentCache.get(chunkX, chunkZ).getComponents();
        this.chunkSource.provideProcessedChunk(containerPrimer, chunkX, chunkZ, structureComponents);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 255; ++y) {
                    chunkPrimer.func_177855_a(x, y, z, containerPrimer.func_177856_a(x, y, z));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Chunk func_185932_a(int chunkX, int chunkZ) {
        void var7_12;
        DebugUtil.startDebug("modernbeta.generateChunk");
        ChunkPrimer chunkPrimer = this.primerPool.get();
        this.func_185976_a(chunkX, chunkZ, chunkPrimer);
        Biome[] biomes = this.initialChunkCache.get((int)chunkX, (int)chunkZ).biomes;
        if (!this.chunkSource.skipChunk(chunkX, chunkZ)) {
            boolean villageGenerated = !this.componentCache.get(chunkX, chunkZ).getComponents().isEmpty();
            this.chunkSource.provideSurface(this.world, biomes, chunkPrimer, chunkX, chunkZ);
            if (this.biomeInjector != null) {
                this.biomeInjector.injectBiomes(biomes, chunkPrimer, this.chunkSource, chunkX, chunkZ, BiomeInjectionStep.POST_SURFACE);
            }
            for (Map.Entry<ResourceLocation, MapGenBase> entry : this.carvers.entrySet()) {
                MapGenBase carver = entry.getValue();
                if (carver instanceof MapGenBetaCave) {
                    List<StructureComponent> structureComponents = this.componentCache.get(chunkX, chunkZ).getComponents();
                    ((MapGenBetaCave)carver).generate(this.world, chunkX, chunkZ, chunkPrimer, biomes, structureComponents);
                    continue;
                }
                if (villageGenerated) continue;
                entry.getValue().func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
            }
            for (Map.Entry<ResourceLocation, MapGenBase> entry : this.structures.entrySet()) {
                if (entry.getKey().equals((Object)ModernBetaStructures.VILLAGE)) continue;
                ((MapGenStructure)entry.getValue()).func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
            }
            this.componentCache.remove(chunkX, chunkZ);
        }
        Chunk chunk = new Chunk(this.world, chunkPrimer, chunkX, chunkZ);
        this.primerPool.release(chunkPrimer);
        byte[] biomeArray = chunk.func_76605_m();
        boolean bl = false;
        while (var7_12 < biomeArray.length) {
            biomeArray[var7_12] = (byte)Biome.func_185362_a((Biome)biomes[var7_12]);
            ++var7_12;
        }
        chunk.func_76603_b();
        DebugUtil.endDebug("modernbeta.generateChunk");
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        this.chunkSource.pruneChunk(this.world, chunkX, chunkZ);
        BlockFalling.field_149832_M = true;
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean hasVillageGenerated = false;
        if (!this.chunkSource.skipChunk(chunkX, chunkZ)) {
            Biome biome = this.world.func_180494_b((BlockPos)mutablePos.func_181079_c(startX + 16, 0, startZ + 16));
            this.random.setSeed(this.world.func_72905_C());
            long randomLong0 = this.random.nextLong() / 2L * 2L + 1L;
            long randomLong1 = this.random.nextLong() / 2L * 2L + 1L;
            this.random.setSeed((long)chunkX * randomLong0 + (long)chunkZ * randomLong1 ^ this.world.func_72905_C());
            ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
            for (Map.Entry<ResourceLocation, MapGenStructure> structureEntry : this.structures.entrySet()) {
                if (structureEntry.getKey().equals((Object)ModernBetaStructures.VILLAGE)) {
                    hasVillageGenerated = structureEntry.getValue().func_175794_a(this.world, this.random, chunkPos);
                    continue;
                }
                structureEntry.getValue().func_175794_a(this.world, this.random, chunkPos);
            }
            this.random.setSeed(this.world.func_72905_C());
            randomLong0 = this.random.nextLong() / 2L * 2L + 1L;
            randomLong1 = this.random.nextLong() / 2L * 2L + 1L;
            this.random.setSeed((long)chunkX * randomLong0 + (long)chunkZ * randomLong1 ^ this.world.func_72905_C());
            boolean populateWaterLakes = TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE);
            if (this.settings.useWaterLakes && populateWaterLakes && !hasVillageGenerated) {
                ModernBetaBiomeDecorator.populateWaterLakes(this.world, this.random, this.settings, mutablePos, chunkX, chunkZ, this.chunkSource.getDefaultFluid());
            }
            boolean populateLavaLakes = TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA);
            if (this.settings.useLavaLakes && populateLavaLakes && !hasVillageGenerated) {
                ModernBetaBiomeDecorator.populateLavaLakes(this.world, this.random, this.settings, mutablePos, chunkX, chunkZ);
            }
            boolean populateDungeons = TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
            if (this.settings.useDungeons && populateDungeons) {
                ModernBetaBiomeDecorator.populateDungeons(this.world, this.random, this.settings, mutablePos, chunkX, chunkZ);
            }
            biome.func_180624_a(this.world, this.random, new BlockPos(startX, 0, startZ));
            if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
                WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(startX + 8), (int)(startZ + 8), (int)16, (int)16, (Random)this.random);
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            ModernBetaBiomeDecorator.populateSnowIce(this.world, this.random, this.biomeProvider, mutablePos, chunkX, chunkZ);
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public void func_185977_a(int chunkX, int chunkZ, ChunkPrimer chunkPrimer, Biome[] biomes) {
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        if (this.chunkSource.skipChunk(chunkX, chunkZ)) {
            return false;
        }
        boolean generated = false;
        if (this.structures.containsKey(ModernBetaStructures.MONUMENT) && chunk.func_177416_w() < 3600L) {
            generated |= this.structures.get(ModernBetaStructures.MONUMENT).func_175794_a(this.world, this.random, new ChunkPos(chunkX, chunkZ));
        }
        return generated;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        MapGenScatteredFeature feature;
        if (this.chunkSource.skipChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return ImmutableList.of();
        }
        Biome biome = this.world.func_180494_b(pos);
        if (creatureType == EnumCreatureType.MONSTER && this.structures.containsKey(ModernBetaStructures.TEMPLE) && (feature = (MapGenScatteredFeature)this.structures.get(ModernBetaStructures.TEMPLE)).func_175798_a(pos)) {
            return feature.func_82667_a();
        }
        if (creatureType == EnumCreatureType.MONSTER && this.structures.containsKey(ModernBetaStructures.MONUMENT) && (feature = (StructureOceanMonument)this.structures.get(ModernBetaStructures.MONUMENT)).func_175796_a(this.world, pos)) {
            return feature.func_175799_b();
        }
        ArrayList<Biome.SpawnListEntry> spawnEntries = new ArrayList<Biome.SpawnListEntry>(biome.func_76747_a(creatureType));
        ModernBetaBiomeMobs.modifySpawnList(spawnEntries, creatureType, biome, this.settings);
        return spawnEntries;
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean findUnexplored) {
        if (this.chunkSource.skipChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return null;
        }
        if (this.structures.isEmpty()) {
            return null;
        }
        ResourceLocation structureKey = new ResourceLocation(structureName.toLowerCase());
        if (this.structures.containsKey(structureKey)) {
            return this.structures.get(structureKey).func_180706_b(world, pos, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        if (this.chunkSource.skipChunk(chunkX, chunkZ)) {
            return;
        }
        if (this.structures.isEmpty()) {
            return;
        }
        for (MapGenStructure structure : this.structures.values()) {
            structure.func_186125_a(this.world, chunkX, chunkZ, null);
        }
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        if (this.chunkSource.skipChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return false;
        }
        if (this.structures.isEmpty()) {
            return false;
        }
        ResourceLocation structureKey = new ResourceLocation(structureName.toLowerCase());
        if (this.structures.containsKey(structureKey)) {
            return this.structures.get(structureKey).func_175795_b(pos);
        }
        return false;
    }

    public void cacheStructureComponent(int chunkX, int chunkZ, StructureComponent structureComponent) {
        this.componentCache.get(chunkX, chunkZ).addComponent(structureComponent);
    }

    public Biome[] getBiomes(int chunkX, int chunkZ) {
        if (this.biomeInjector.hasNoRules()) {
            return this.biomeProvider.getBaseBiomes(chunkX, chunkZ);
        }
        return this.initialChunkCache.get((int)chunkX, (int)chunkZ).biomes;
    }

    public ChunkSource getChunkSource() {
        return this.chunkSource;
    }

    public ModernBetaGeneratorSettings getGeneratorSettings() {
        return this.settings;
    }

    private Map<ResourceLocation, MapGenStructure> initStructures(ModernBetaGeneratorSettings settings, boolean mapFeaturesEnabled) {
        LinkedHashMap<ResourceLocation, MapGenStructure> structureMap = new LinkedHashMap<ResourceLocation, MapGenStructure>();
        if (mapFeaturesEnabled) {
            if (settings.useVillages) {
                structureMap.put(ModernBetaStructures.VILLAGE, (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE));
            }
            if (settings.useStrongholds) {
                structureMap.put(ModernBetaStructures.STRONGHOLD, (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD));
            }
            if (settings.useMineShafts) {
                structureMap.put(ModernBetaStructures.MINESHAFT, (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT));
            }
            if (settings.useMonuments) {
                structureMap.put(ModernBetaStructures.MONUMENT, (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new StructureOceanMonument(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT));
            }
            if (settings.useMansions) {
                structureMap.put(ModernBetaStructures.MANSION, (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new WoodlandMansion((ChunkGeneratorOverworld)this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.WOODLAND_MANSION));
            }
            if (settings.useTemples) {
                structureMap.put(ModernBetaStructures.TEMPLE, (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new MapGenScatteredFeature(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE));
            }
        }
        return structureMap;
    }

    private ChunkPrimerContainer provideInitialChunk(int chunkX, int chunkZ) {
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        Biome[] biomes = this.biomeProvider.getBaseBiomes(chunkX, chunkZ);
        this.chunkSource.provideInitialChunk(chunkPrimer, chunkX, chunkZ);
        if (this.biomeInjector != null) {
            this.biomeInjector.injectBiomes(biomes, chunkPrimer, this.chunkSource, chunkX, chunkZ, BiomeInjectionStep.PRE_SURFACE);
            this.biomeInjector.injectBiomes(biomes, chunkPrimer, this.chunkSource, chunkX, chunkZ, BiomeInjectionStep.CUSTOM);
        }
        return new ChunkPrimerContainer(chunkPrimer, biomes);
    }

    private static class ChunkPrimerContainer {
        public final ChunkPrimer chunkPrimer;
        public final Biome[] biomes;

        public ChunkPrimerContainer(ChunkPrimer chunkPrimer, Biome[] biomes) {
            this.chunkPrimer = chunkPrimer;
            this.biomes = biomes;
        }
    }
}

