/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.chunk.source;

import java.util.Random;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoiseCombined;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkPrimer;
import org.apache.logging.log4j.Level;

public class Classic23aChunkSource
extends FiniteChunkSource {
    private final PerlinOctaveNoiseCombined lowOctaveNoise;
    private final PerlinOctaveNoiseCombined highOctaveNoise;
    private final PerlinOctaveNoise selectorOctaveNoise;
    private final PerlinOctaveNoiseCombined erodeSelectorOctaveNoise;
    private final PerlinOctaveNoiseCombined erodeOctaveNoise;
    private final PerlinOctaveNoise soilOctaveNoise;
    private PerlinOctaveNoise sandOctaveNoise;
    private PerlinOctaveNoise gravelOctaveNoise;
    private final int seaLevel;

    public Classic23aChunkSource(long seed, ModernBetaGeneratorSettings settings) {
        super(seed, settings);
        this.lowOctaveNoise = new PerlinOctaveNoiseCombined(this.random, 8, false);
        this.highOctaveNoise = new PerlinOctaveNoiseCombined(this.random, 8, false);
        this.selectorOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        this.erodeSelectorOctaveNoise = new PerlinOctaveNoiseCombined(this.random, 8, false);
        this.erodeOctaveNoise = new PerlinOctaveNoiseCombined(this.random, 8, false);
        this.soilOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        this.seaLevel = this.levelHeight / 2;
        this.setCloudHeight(this.seaLevel + 34);
    }

    @Override
    public int getSeaLevel() {
        return this.seaLevel;
    }

    @Override
    protected void pregenerateTerrain() {
        this.setPhase("Raising");
        this.raiseLevel();
        this.setPhase("Eroding");
        this.erodeLevel();
        this.setPhase("Soiling");
        this.soilLevel();
        if (this.settings.useIndevCaves) {
            this.setPhase("Carving");
            this.carveLevel();
        }
        this.oreLevel();
        this.setPhase("Watering");
        this.waterLevel();
        this.setPhase("Melting");
        this.meltLevel();
        this.setPhase("Growing");
        this.growLevel();
        this.setPhase("Assembling");
        this.assembleLevel();
    }

    @Override
    protected void generateBorder(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        int seaLevel = this.getSeaLevel();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.levelHeight; ++y) {
                    if (y < seaLevel - 2) {
                        chunkPrimer.func_177855_a(x, y, z, BlockStates.BEDROCK);
                        continue;
                    }
                    if (y >= seaLevel) continue;
                    chunkPrimer.func_177855_a(x, y, z, this.defaultFluid);
                }
            }
        }
    }

    @Override
    protected int getBorderHeight(int x, int z, HeightmapChunk.Type type) {
        return type == HeightmapChunk.Type.OCEAN ? this.seaLevel - 1 : this.seaLevel - 3;
    }

    private void raiseLevel() {
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            for (int z = 0; z < this.levelLength; ++z) {
                double height;
                double heightLow = this.lowOctaveNoise.sample((float)x * 1.3f, (float)z * 1.3f) / 8.0 - 8.0;
                double heightHigh = this.highOctaveNoise.sample((float)x * 1.3f, (float)z * 1.3f) / 6.0 + 6.0;
                double heightSelector = this.selectorOctaveNoise.sampleXY(x, z) / 8.0;
                if (heightSelector > 0.0) {
                    heightHigh = heightLow;
                }
                if ((height = Math.max(heightLow, heightHigh) / 2.0) < 0.0) {
                    height *= 0.8;
                }
                this.levelHeightmap[x + z * this.levelWidth] = (int)height;
            }
        }
    }

    private void erodeLevel() {
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            for (int z = 0; z < this.levelLength; ++z) {
                int erodeNoise;
                double erodeSelector = this.erodeSelectorOctaveNoise.sample(x << 1, z << 1) / 8.0;
                int n = erodeNoise = this.erodeOctaveNoise.sample(x << 1, z << 1) > 0.0 ? 1 : 0;
                if (!(erodeSelector > 2.0)) continue;
                int height = this.levelHeightmap[x + z * this.levelWidth];
                this.levelHeightmap[x + z * this.levelWidth] = height = ((height - erodeNoise) / 2 << 1) + erodeNoise;
            }
        }
    }

    private void soilLevel() {
        int seaLevel = this.getSeaLevel();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            int worldX = x - this.levelWidth / 2;
            for (int z = 0; z < this.levelLength; ++z) {
                int worldZ = z - this.levelLength / 2;
                int dirtDepth = (int)(this.soilOctaveNoise.sampleXY(x, z) / 24.0) - 4;
                int dirtThreshold = this.levelHeightmap[x + z * this.levelWidth] + seaLevel;
                int stoneThreshold = dirtDepth + dirtThreshold;
                this.levelHeightmap[x + z * this.levelWidth] = Math.max(dirtThreshold, stoneThreshold);
                if (this.levelHeightmap[x + z * this.levelWidth] > this.levelHeight - 2) {
                    this.levelHeightmap[x + z * this.levelWidth] = this.levelHeight - 2;
                }
                if (this.levelHeightmap[x + z * this.levelWidth] <= 0) {
                    this.levelHeightmap[x + z * this.levelWidth] = 1;
                }
                blockPos.func_181079_c(worldX, 0, worldZ);
                for (int y = 0; y < this.levelHeight; ++y) {
                    Block block = Blocks.field_150350_a;
                    if (y <= dirtThreshold) {
                        block = Blocks.field_150346_d;
                    }
                    if (y <= stoneThreshold) {
                        block = this.defaultBlock.func_177230_c();
                    }
                    this.setLevelBlock(x, y, z, block);
                }
            }
        }
    }

    private void carveLevel() {
        int caveCount = this.levelWidth * this.levelLength * this.levelHeight / 256 / 64;
        Random tunnelRandom = new Random(this.seed);
        for (int i = 0; i < caveCount; ++i) {
            this.setPhaseProgress((float)i / (float)(caveCount - 1));
            float caveX = this.random.nextFloat() * (float)this.levelWidth;
            float caveY = this.random.nextFloat() * (float)this.levelHeight;
            float caveZ = this.random.nextFloat() * (float)this.levelLength;
            int caveLen = (int)((this.random.nextFloat() + this.random.nextFloat()) * 75.0f);
            float theta = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
            float deltaTheta = 0.0f;
            float phi = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
            float deltaPhi = 0.0f;
            float caveWidth = MathUtil.getRandomFloatInRange(1.0f, this.levelCaveWidth, tunnelRandom);
            for (int len = 0; len < caveLen; ++len) {
                caveX += (float)(Math.sin(theta) * Math.cos(phi));
                caveZ += (float)(Math.cos(theta) * Math.cos(phi));
                caveY += (float)Math.sin(phi);
                theta += deltaTheta * 0.2f;
                deltaTheta *= 0.9f;
                deltaTheta += this.random.nextFloat() - this.random.nextFloat();
                phi += deltaPhi * 0.5f;
                phi *= 0.5f;
                deltaPhi *= 0.9f;
                deltaPhi += this.random.nextFloat() - this.random.nextFloat();
                if (!(this.random.nextFloat() >= 0.3f)) continue;
                float centerX = caveX + this.random.nextFloat() * 4.0f - 2.0f;
                float centerY = caveY + this.random.nextFloat() * 4.0f - 2.0f;
                float centerZ = caveZ + this.random.nextFloat() * 4.0f - 2.0f;
                float radius = (float)((Math.sin((double)len * Math.PI / (double)caveLen) * 2.5 + 1.0) * (double)caveWidth);
                this.fillOblateSpheroid(centerX, centerY, centerZ, radius, Blocks.field_150350_a);
            }
        }
    }

    private void oreLevel() {
        this.generateDummyOre(Blocks.field_150365_q, 90);
        this.generateDummyOre(Blocks.field_150366_p, 70);
        this.generateDummyOre(Blocks.field_150352_o, 50);
    }

    private void waterLevel() {
        Block fluidBlock = this.defaultFluid.func_177230_c();
        int seaLevel = this.getSeaLevel();
        int flooded = 0;
        for (int x = 0; x < this.levelWidth; ++x) {
            flooded += this.flood(x, seaLevel - 1, 0, fluidBlock, Blocks.field_150350_a);
            flooded += this.flood(x, seaLevel - 1, this.levelLength - 1, fluidBlock, Blocks.field_150350_a);
        }
        for (int z = 0; z < this.levelLength; ++z) {
            flooded += this.flood(this.levelWidth - 1, seaLevel - 1, z, fluidBlock, Blocks.field_150350_a);
            flooded += this.flood(0, seaLevel - 1, z, fluidBlock, Blocks.field_150350_a);
        }
        int waterSourceCount = this.levelWidth * this.levelLength / 200;
        for (int i = 0; i < waterSourceCount; ++i) {
            int randZ;
            int randY;
            int randX;
            if (i % 100 == 0) {
                this.setPhaseProgress((float)i / (float)(waterSourceCount - 1));
            }
            if (this.getLevelBlock(randX = this.random.nextInt(this.levelWidth), randY = seaLevel - 1 - this.random.nextInt(3), randZ = this.random.nextInt(this.levelLength)) != Blocks.field_150350_a) continue;
            flooded += this.flood(randX, randY, randZ, fluidBlock, Blocks.field_150350_a);
        }
        ModernBeta.log(Level.DEBUG, String.format("Flood filled %d tiles", flooded));
    }

    private void meltLevel() {
        int attempts = 0;
        int lavaSourceCount = this.levelWidth * this.levelLength * this.levelHeight / 10000;
        for (int i = 0; i < lavaSourceCount; ++i) {
            int randZ;
            int randY;
            int randX;
            if (i % 100 == 0) {
                this.setPhaseProgress((float)i / (float)(lavaSourceCount - 1));
            }
            if (this.getLevelBlock(randX = this.random.nextInt(this.levelWidth), randY = this.random.nextInt(this.getSeaLevel() - 4), randZ = this.random.nextInt(this.levelLength)) != Blocks.field_150350_a) continue;
            this.flood(randX, randY, randZ, (Block)Blocks.field_150353_l, Blocks.field_150350_a);
            ++attempts;
        }
        ModernBeta.log(Level.DEBUG, String.format("LavaCount: %d", attempts));
    }

    private void growLevel() {
        this.sandOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        this.gravelOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        int seaLevel = this.getSeaLevel();
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            for (int z = 0; z < this.levelLength; ++z) {
                boolean genSand = this.sandOctaveNoise.sampleXY(x, z) > 8.0;
                boolean genGravel = this.gravelOctaveNoise.sampleXY(x, z) > 12.0;
                int height = this.levelHeightmap[x + z * this.levelWidth];
                Block blockUp = this.getLevelBlock(x, height + 1, z);
                if (blockUp == this.defaultFluid.func_177230_c() && height <= seaLevel - 1 && genGravel) {
                    this.setLevelBlock(x, height, z, Blocks.field_150351_n);
                }
                if (blockUp != Blocks.field_150350_a) continue;
                BlockGrass surfaceBlock = Blocks.field_150349_c;
                if (height <= seaLevel - 1 && genSand) {
                    surfaceBlock = Blocks.field_150354_m;
                }
                this.setLevelBlock(x, height, z, (Block)surfaceBlock);
            }
        }
    }

    private void assembleLevel() {
        for (int x = 0; x < this.levelWidth; ++x) {
            this.setPhaseProgress((float)x / (float)(this.levelWidth - 1));
            for (int z = 0; z < this.levelLength; ++z) {
                this.setLevelBlock(x, 0, z, Blocks.field_150357_h);
            }
        }
    }

    private void generateDummyOre(Block block, int count) {
        int attempts = this.levelWidth * this.levelLength * this.levelHeight / 256 / 64 * count / 100;
        for (int i = 0; i < attempts; ++i) {
            this.random.nextFloat();
            this.random.nextFloat();
            this.random.nextFloat();
            int randSize = (int)((this.random.nextFloat() + this.random.nextFloat()) * 75.0f * (float)count / 100.0f);
            this.random.nextFloat();
            this.random.nextFloat();
            for (int j = 0; j < randSize; ++j) {
                this.random.nextFloat();
                this.random.nextFloat();
                this.random.nextFloat();
                this.random.nextFloat();
            }
        }
    }
}

