/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenClay
extends WorldGenerator {
    private final Block block = Blocks.field_150435_aG;
    private final int numberOfBlocks;

    public WorldGenClay(int numberOfBlocks) {
        this.numberOfBlocks = numberOfBlocks;
    }

    public boolean func_180709_b(World world, Random random, BlockPos blockPos) {
        if (world.func_180495_p(blockPos).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int originX = blockPos.func_177958_n();
        int originY = blockPos.func_177956_o();
        int originZ = blockPos.func_177952_p();
        float radius = random.nextFloat() * 3.141593f;
        double x0 = (float)(originX + 8) + MathHelper.func_76126_a((float)radius) * (float)this.numberOfBlocks / 8.0f;
        double x1 = (float)(originX + 8) - MathHelper.func_76126_a((float)radius) * (float)this.numberOfBlocks / 8.0f;
        double z0 = (float)(originZ + 8) + MathHelper.func_76134_b((float)radius) * (float)this.numberOfBlocks / 8.0f;
        double z1 = (float)(originZ + 8) - MathHelper.func_76134_b((float)radius) * (float)this.numberOfBlocks / 8.0f;
        double y0 = originY + random.nextInt(3) + 2;
        double y1 = originY + random.nextInt(3) + 2;
        for (int block = 0; block <= this.numberOfBlocks; ++block) {
            double d6 = x0 + (x1 - x0) * (double)block / (double)this.numberOfBlocks;
            double d7 = y0 + (y1 - y0) * (double)block / (double)this.numberOfBlocks;
            double d8 = z0 + (z1 - z0) * (double)block / (double)this.numberOfBlocks;
            double d9 = random.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)block * 3.141593f / (float)this.numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)block * 3.141593f / (float)this.numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int minX = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int maxX = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int minY = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int maxY = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int minZ = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int maxZ = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Block curBlock;
                        double dX = ((double)x + 0.5 - d6) / (d10 / 2.0);
                        double dY = ((double)y + 0.5 - d7) / (d11 / 2.0);
                        double dZ = ((double)z + 0.5 - d8) / (d10 / 2.0);
                        if (dX * dX + dY * dY + dZ * dZ >= 1.0 || (curBlock = world.func_180495_p((BlockPos)mutablePos.func_181079_c(x, y, z)).func_177230_c()) != Blocks.field_150354_m) continue;
                        world.func_175656_a((BlockPos)mutablePos, this.block.func_176223_P());
                    }
                }
            }
        }
        return true;
    }
}

