/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.feature;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenFancyOak
extends WorldGenAbstractTree {
    private static final Set<Block> DIRT_REPLACEABLE = Stream.of(BlockStates.DIRT.func_177230_c(), BlockStates.GRASS_BLOCK.func_177230_c()).collect(Collectors.toCollection(HashSet::new));
    private static final byte[] AXIS_LOOKUP = new byte[]{2, 0, 0, 1, 2, 1};
    private static final int FOLIAGE_BLOB_HEIGHT = 5;
    private static final int TREE_MAX_HEIGHT = 12;

    public WorldGenFancyOak(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Random treeRandom = new Random(random.nextLong());
        TreeInfo treeInfo = new TreeInfo();
        treeInfo.setHeight(5 + treeRandom.nextInt(12));
        if (this.canGenerate(world, pos, treeInfo)) {
            this.initializeTree(world, pos, treeRandom, treeInfo);
            this.placeFoliageBlobs(world, pos, treeInfo);
            this.placeTreeTrunk(world, pos, treeInfo);
            this.placeTreeBranches(world, pos, treeInfo);
            return true;
        }
        return false;
    }

    private boolean canGenerate(World world, BlockPos basePos, TreeInfo treeInfo) {
        int[] treeStartPos = new int[]{basePos.func_177958_n(), basePos.func_177956_o(), basePos.func_177952_p()};
        int[] treeEndPos = new int[]{basePos.func_177958_n(), basePos.func_177956_o() + treeInfo.getHeight() - 1, basePos.func_177952_p()};
        BlockPos treeBasePos = new BlockPos(basePos.func_177958_n(), basePos.func_177956_o() - 1, basePos.func_177952_p());
        BlockPos treeBasePosUp = treeBasePos.func_177984_a();
        IBlockState blockState = world.func_180495_p(treeBasePos);
        IBlockState blockStateUp = world.func_180495_p(treeBasePosUp);
        if (!blockStateUp.func_177230_c().isAir(blockStateUp, (IBlockAccess)world, treeBasePosUp)) {
            return false;
        }
        if (!DIRT_REPLACEABLE.contains(blockState.func_177230_c())) {
            return false;
        }
        int testHeight = this.getBranchLength(world, treeStartPos, treeEndPos);
        if (testHeight == -1) {
            return true;
        }
        return testHeight >= 6;
    }

    private void initializeTree(World world, BlockPos basePos, Random random, TreeInfo treeInfo) {
        int foliageBlobCount;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (DIRT_REPLACEABLE.contains(world.func_180495_p((BlockPos)mutable.func_181079_c(basePos.func_177958_n(), basePos.func_177956_o() - 1, basePos.func_177952_p())).func_177230_c())) {
            world.func_180501_a((BlockPos)mutable, BlockStates.DIRT, 0);
        }
        treeInfo.setTreeHeight((int)((double)treeInfo.getHeight() * 0.618));
        if (treeInfo.getTreeHeight() >= treeInfo.getHeight()) {
            treeInfo.setTreeHeight(treeInfo.getHeight() - 1);
        }
        if ((foliageBlobCount = (int)(1.382 + Math.pow((double)treeInfo.getHeight() / 13.0, 2.0))) <= 0) {
            foliageBlobCount = 1;
        }
        int foliageBaseY = basePos.func_177956_o() + treeInfo.getHeight() - 5;
        int treeTopY = basePos.func_177956_o() + treeInfo.treeHeight;
        int treeRelY = foliageBaseY - basePos.func_177956_o();
        int blobCount = 1;
        int[][] foliageBlobPositions = new int[foliageBlobCount * treeInfo.getHeight()][4];
        foliageBlobPositions[0][0] = basePos.func_177958_n();
        foliageBlobPositions[0][1] = foliageBaseY--;
        foliageBlobPositions[0][2] = basePos.func_177952_p();
        foliageBlobPositions[0][3] = treeTopY;
        while (treeRelY >= 0) {
            float foliageDistance = this.getFoliageDistance(treeRelY, treeInfo);
            if (foliageDistance >= 0.0f) {
                for (int currentBlobCount = 0; currentBlobCount < foliageBlobCount; ++currentBlobCount) {
                    int[] endPos;
                    int randZ;
                    double randAngle;
                    double randRadius = (double)foliageDistance * ((double)random.nextFloat() + 0.328);
                    int randX = (int)(randRadius * Math.sin(randAngle = (double)random.nextFloat() * 2.0 * 3.14159) + (double)basePos.func_177958_n() + 0.5);
                    int[] startPos = new int[]{randX, foliageBaseY, randZ = (int)(randRadius * Math.cos(randAngle) + (double)basePos.func_177952_p() + 0.5)};
                    if (this.getBranchLength(world, startPos, endPos = new int[]{randX, foliageBaseY + 5, randZ}) != -1) continue;
                    endPos = new int[]{basePos.func_177958_n(), basePos.func_177956_o(), basePos.func_177952_p()};
                    double distance = Math.sqrt(Math.pow(Math.abs(basePos.func_177958_n() - startPos[0]), 2.0) + Math.pow(Math.abs(basePos.func_177952_p() - startPos[2]), 2.0)) * 0.381;
                    endPos[1] = (double)startPos[1] - distance > (double)treeTopY ? treeTopY : (int)((double)startPos[1] - distance);
                    if (this.getBranchLength(world, endPos, startPos) != -1) continue;
                    foliageBlobPositions[blobCount][0] = randX;
                    foliageBlobPositions[blobCount][1] = foliageBaseY;
                    foliageBlobPositions[blobCount][2] = randZ;
                    foliageBlobPositions[blobCount][3] = endPos[1];
                    ++blobCount;
                }
            }
            --foliageBaseY;
            --treeRelY;
        }
        int[][] finalFoliageBlobPositions = new int[blobCount][4];
        System.arraycopy(foliageBlobPositions, 0, finalFoliageBlobPositions, 0, blobCount);
        treeInfo.setFoliageBlobPositions(finalFoliageBlobPositions);
    }

    private void placeFoliageBlobs(World world, BlockPos basePos, TreeInfo treeInfo) {
        int[][] foliageBlobPositions = treeInfo.getFoliageBlobPositions();
        for (int curBlob = 0; curBlob < foliageBlobPositions.length; ++curBlob) {
            int x = foliageBlobPositions[curBlob][0];
            int y = foliageBlobPositions[curBlob][1];
            int z = foliageBlobPositions[curBlob][2];
            this.placeFoliageBlob(world, x, y, z);
        }
    }

    private void placeTreeTrunk(World world, BlockPos basePos, TreeInfo treeInfo) {
        int x = basePos.func_177958_n();
        int z = basePos.func_177952_p();
        int startY = basePos.func_177956_o();
        int topY = basePos.func_177956_o() + treeInfo.getTreeHeight();
        int[] startPos = new int[]{x, startY, z};
        int[] endPos = new int[]{x, topY, z};
        this.placeBranch(world, startPos, endPos, BlockStates.OAK_LOG);
    }

    private void placeTreeBranches(World world, BlockPos basePos, TreeInfo treeInfo) {
        int[] branchStartPos = new int[]{basePos.func_177958_n(), basePos.func_177956_o(), basePos.func_177952_p()};
        int[][] foliageBlobPositions = treeInfo.getFoliageBlobPositions();
        for (int curBranch = 0; curBranch < foliageBlobPositions.length; ++curBranch) {
            int[] foliageBlobPos = foliageBlobPositions[curBranch];
            int[] branchEndPos = new int[]{foliageBlobPos[0], foliageBlobPos[1], foliageBlobPos[2]};
            branchStartPos[1] = foliageBlobPos[3];
            int relY = branchStartPos[1] - basePos.func_177956_o();
            if (!((double)relY >= (double)treeInfo.getHeight() * 0.2)) continue;
            this.placeBranch(world, branchStartPos, branchEndPos, BlockStates.OAK_LOG);
        }
    }

    private void placeBranch(World world, int[] startPos, int[] endPos, IBlockState state) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int[] distance = new int[]{0, 0, 0};
        int sideNdx = 0;
        int longestSideNdx = 0;
        for (sideNdx = 0; sideNdx < 3; sideNdx = (int)((byte)(sideNdx + 1))) {
            distance[sideNdx] = endPos[sideNdx] - startPos[sideNdx];
            if (Math.abs(distance[sideNdx]) <= Math.abs(distance[longestSideNdx])) continue;
            longestSideNdx = sideNdx;
        }
        if (distance[longestSideNdx] != 0) {
            byte ndx0 = AXIS_LOOKUP[longestSideNdx];
            byte ndx1 = AXIS_LOOKUP[longestSideNdx + 3];
            int branchDir = distance[longestSideNdx] > 0 ? 1 : -1;
            double branchStep0 = (double)distance[ndx0] / (double)distance[longestSideNdx];
            double branchStep1 = (double)distance[ndx1] / (double)distance[longestSideNdx];
            int[] pos = new int[3];
            int endOffset = distance[longestSideNdx] + branchDir;
            for (int offset = 0; offset != endOffset; offset += branchDir) {
                pos[longestSideNdx] = MathHelper.func_76128_c((double)((double)(startPos[longestSideNdx] + offset) + 0.5));
                pos[ndx0] = MathHelper.func_76128_c((double)((double)startPos[ndx0] + (double)offset * branchStep0 + 0.5));
                pos[ndx1] = MathHelper.func_76128_c((double)((double)startPos[ndx1] + (double)offset * branchStep1 + 0.5));
                world.func_175656_a((BlockPos)mutable.func_181079_c(pos[0], pos[1], pos[2]), state);
            }
        }
    }

    private void placeLayer(World world, int x, int y, int z, float radius, byte axis, IBlockState state) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int layerRadius = (int)((double)radius + 0.618);
        byte ndx0 = AXIS_LOOKUP[axis];
        byte ndx1 = AXIS_LOOKUP[axis + 3];
        int[] centerPos = new int[]{x, y, z};
        int[] pos = new int[]{0, 0, 0};
        for (int off1 = -layerRadius; off1 <= layerRadius; ++off1) {
            for (int off2 = -layerRadius; off2 <= layerRadius; ++off2) {
                double foliageDist = Math.sqrt(Math.pow((double)Math.abs(off1) + 0.5, 2.0) + Math.pow((double)Math.abs(off2) + 0.5, 2.0));
                if (foliageDist > (double)radius) continue;
                pos[ndx0] = centerPos[ndx0] + off1;
                pos[1] = centerPos[1];
                pos[ndx1] = centerPos[ndx1] + off2;
                IBlockState blockState = world.func_180495_p((BlockPos)mutable.func_181079_c(pos[0], pos[1], pos[2]));
                if (blockState.func_177230_c() != Blocks.field_150350_a && blockState.func_177230_c() != Blocks.field_150362_t) continue;
                world.func_175656_a((BlockPos)mutable.func_181079_c(pos[0], pos[1], pos[2]), state);
            }
        }
    }

    private void placeFoliageBlob(World world, int x, int y, int z) {
        int topY = y + 5;
        for (int curY = y; curY < topY; ++curY) {
            int blobRelY = curY - y;
            float radius = this.getFoliageBlobRadius(blobRelY);
            this.placeLayer(world, x, curY, z, radius, (byte)1, BlockStates.OAK_LEAVES);
        }
    }

    private float getFoliageBlobRadius(int blobRelY) {
        return blobRelY >= 0 && blobRelY < 5 ? (blobRelY != 0 && blobRelY != 4 ? 3.0f : 2.0f) : -1.0f;
    }

    private float getFoliageDistance(int treeRelY, TreeInfo treeInfo) {
        float distance;
        if ((double)treeRelY < (double)treeInfo.getHeight() * 0.3) {
            distance = -1.618f;
        } else {
            float treeRadius = (float)treeInfo.getHeight() / 2.0f;
            float distFromRadius = treeRadius - (float)treeRelY;
            distance = distFromRadius == 0.0f ? treeRadius : (Math.abs(distFromRadius) >= treeRadius ? 0.0f : (float)Math.sqrt(treeRadius * treeRadius - distFromRadius * distFromRadius));
            distance *= 0.5f;
        }
        return distance;
    }

    private int getBranchLength(World world, int[] startPos, int[] endPos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int[] distance = new int[]{0, 0, 0};
        int sideNdx = 0;
        int longestSideNdx = 0;
        for (sideNdx = 0; sideNdx < 3; sideNdx = (int)((byte)(sideNdx + 1))) {
            distance[sideNdx] = endPos[sideNdx] - startPos[sideNdx];
            if (Math.abs(distance[sideNdx]) <= Math.abs(distance[longestSideNdx])) continue;
            longestSideNdx = sideNdx;
        }
        if (distance[longestSideNdx] != 0) {
            int offset;
            byte ndx0 = AXIS_LOOKUP[longestSideNdx];
            byte ndx1 = AXIS_LOOKUP[longestSideNdx + 3];
            int branchDir = distance[longestSideNdx] > 0 ? 1 : -1;
            double branchStep0 = (double)distance[ndx0] / (double)distance[longestSideNdx];
            double branchStep1 = (double)distance[ndx1] / (double)distance[longestSideNdx];
            int[] pos = new int[]{0, 0, 0};
            int endOffset = distance[longestSideNdx] + branchDir;
            for (offset = 0; offset != endOffset; offset += branchDir) {
                pos[longestSideNdx] = startPos[longestSideNdx] + offset;
                pos[ndx0] = MathHelper.func_76128_c((double)((double)startPos[ndx0] + (double)offset * branchStep0));
                pos[ndx1] = MathHelper.func_76128_c((double)((double)startPos[ndx1] + (double)offset * branchStep1));
                IBlockState blockState = world.func_180495_p((BlockPos)mutable.func_181079_c(pos[0], pos[1], pos[2]));
                if (blockState.func_177230_c() != Blocks.field_150350_a && blockState.func_177230_c() == Blocks.field_150362_t) break;
            }
            if (offset == endOffset) {
                return -1;
            }
            return Math.abs(offset);
        }
        return -1;
    }

    private static class TreeInfo {
        private int height = -1;
        private int treeHeight = -1;
        private int[][] foliageBlobPositions = null;

        private TreeInfo() {
        }

        private int getHeight() {
            return this.height;
        }

        private int getTreeHeight() {
            return this.treeHeight;
        }

        private int[][] getFoliageBlobPositions() {
            return this.foliageBlobPositions;
        }

        private void setHeight(int height) {
            this.height = height;
        }

        private void setTreeHeight(int treeHeight) {
            this.treeHeight = treeHeight;
        }

        private void setFoliageBlobPositions(int[][] foliageBlobPositions) {
            this.foliageBlobPositions = foliageBlobPositions;
        }
    }
}

