/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.structure;

import java.util.List;
import java.util.function.Predicate;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.NoiseChunkSource;
import mod.bespectacled.modernbetaforge.mixin.accessor.AccessorStructureStart;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class StructureWeightSampler {
    private static final float[] STRUCTURE_WEIGHTS = new float[13824];
    private final List<StructureComponent> structureComponents;

    public StructureWeightSampler(List<StructureComponent> structureComponents) {
        this.structureComponents = structureComponents;
    }

    public double sample(ChunkSource chunkSource, BlockPos blockPos) {
        if (this.structureComponents == null) {
            return 0.0;
        }
        int posX = blockPos.func_177958_n();
        int posY = blockPos.func_177956_o();
        int posZ = blockPos.func_177952_p();
        double density = 0.0;
        for (int i = 0; i < this.structureComponents.size(); ++i) {
            StructureBoundingBox box = this.structureComponents.get(i).func_74874_b();
            int height = StructureWeightSampler.getStructureHeight(chunkSource, box);
            int x = Math.max(0, Math.max(box.field_78897_a - posX, posX - box.field_78893_d));
            int z = Math.max(0, Math.max(box.field_78896_c - posZ, posZ - box.field_78892_f));
            int y = posY - height - 1;
            density += StructureWeightSampler.getStructureWeight(x, y, z) * 0.8;
        }
        return density;
    }

    public static int getStructureHeight(ChunkSource chunkSource, StructureBoundingBox boundingBox) {
        int centerX = boundingBox.field_78897_a + boundingBox.func_78883_b() / 2;
        int centerZ = boundingBox.field_78896_c + boundingBox.func_78880_d() / 2;
        return chunkSource.getHeight(centerX, centerZ, HeightmapChunk.Type.STRUCTURE);
    }

    public static int cacheStructures(ModernBetaChunkGenerator chunkGenerator, StructureStart start, Predicate<StructureComponent> excluder) {
        ChunkSource chunkSource = chunkGenerator.getChunkSource();
        int numComponents = 0;
        if (chunkSource instanceof NoiseChunkSource) {
            AccessorStructureStart accessor = (AccessorStructureStart)start;
            for (StructureComponent component : accessor.getComponents()) {
                if (excluder.test(component)) continue;
                StructureBoundingBox box = component.func_74874_b();
                int minChunkX = box.field_78897_a >> 4;
                int minChunkZ = box.field_78896_c >> 4;
                int maxChunkX = box.field_78893_d >> 4;
                int maxChunkZ = box.field_78892_f >> 4;
                for (int componentChunkZ = minChunkZ - 1; componentChunkZ <= maxChunkZ + 1; ++componentChunkZ) {
                    for (int componentChunkX = minChunkX - 1; componentChunkX <= maxChunkX + 1; ++componentChunkX) {
                        chunkGenerator.cacheStructureComponent(componentChunkX, componentChunkZ, component);
                    }
                }
                ++numComponents;
            }
        }
        return numComponents;
    }

    private static double getStructureWeight(int x, int y, int z) {
        if (!(StructureWeightSampler.validIndex(x += 12) && StructureWeightSampler.validIndex(y += 12) && StructureWeightSampler.validIndex(z += 12))) {
            return 0.0;
        }
        return STRUCTURE_WEIGHTS[z * 24 * 24 + x * 24 + y];
    }

    private static float calculateStructureWeight(double x, double y, double z) {
        double magnitude = x * x + y * y + z * z;
        double weight = Math.pow(Math.E, -magnitude / 16.0);
        return (float)(weight * (-y * MathHelper.func_181161_i((double)(magnitude / 2.0)) / 2.0));
    }

    private static boolean validIndex(int index) {
        return index >= 0 && index < 24;
    }

    static {
        for (int z = 0; z < 24; ++z) {
            for (int x = 0; x < 24; ++x) {
                for (int y = 0; y < 24; ++y) {
                    StructureWeightSampler.STRUCTURE_WEIGHTS[z * 24 * 24 + x * 24 + y] = StructureWeightSampler.calculateStructureWeight(x - 12, (double)y - 11.5, z - 12);
                }
            }
        }
    }
}

