/*
 * Decompiled with CFR 0.152.
 */
package net.eve0415.ifpatcher.patch;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import net.eve0415.ifpatcher.IFPatcher;
import net.eve0415.ifpatcher.Patch;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatchPump
extends Patch {
    public static IFluidTank tank;
    public static String fluid;
    public static World world;
    public static BlockPos pos;

    public PatchPump(byte[] inputClass) {
        super(inputClass);
    }

    public static void beforeWork(IFluidTank t, String f, World w, BlockPos p) {
        tank = t;
        fluid = f;
        world = w;
        pos = p;
    }

    public static float work(Block pump, AxisAlignedBB area) {
        if (WorkUtils.isDisabled((Block)pump) || fluid == null || tank.getFluidAmount() + 1000 > tank.getCapacity()) {
            return 0.0f;
        }
        if (!PatchPump.isBlockSameFluid(pos.func_177977_b())) {
            return 0.0f;
        }
        BlockPos farthestFluid = PatchPump.getFarthestFluid(area);
        if (farthestFluid == null) {
            return 0.0f;
        }
        FluidStack willPump = Objects.requireNonNull(FluidUtil.getFluidHandler((World)world, (BlockPos)farthestFluid, null)).drain(1000, true);
        if (BlockRegistry.fluidPumpBlock.isReplaceFluidWithCobble()) {
            world.func_175656_a(farthestFluid, Blocks.field_150347_e.func_176223_P());
        } else {
            world.func_175698_g(farthestFluid);
        }
        tank.fill(willPump, true);
        return 1.0f;
    }

    public static BlockPos getFarthestFluid(AxisAlignedBB area) {
        List blocks;
        int offsetY = 0;
        do {
            blocks = BlockUtils.getBlockPosInAABB((AxisAlignedBB)area.func_72317_d(0.0, (double)(--offsetY), 0.0));
            blocks.removeIf(pos -> world.func_189509_E(pos) || !PatchPump.isFullFluid(pos) || !PatchPump.isBlockSameFluid(pos));
        } while (!blocks.isEmpty());
        int y = PatchPump.pos.func_177956_o() + ++offsetY;
        PriorityQueue<Object> queue = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).func_177957_d((double)pos.func_177958_n(), (double)y, (double)pos.func_177952_p())).reversed());
        queue.addAll(BlockUtils.getBlockPosInAABB((AxisAlignedBB)area.func_72317_d(0.0, (double)offsetY, 0.0)));
        queue.removeIf(pos -> world.func_189509_E(pos) || !PatchPump.isFullFluid(pos) || !PatchPump.isBlockSameFluid(pos));
        return (BlockPos)queue.poll();
    }

    public static boolean isBlockSameFluid(BlockPos pos) {
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)world.func_180495_p(pos).func_177230_c());
        return f != null && f.getName().equals(fluid);
    }

    public static boolean isFullFluid(BlockPos pos) {
        IFluidHandler f = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, null);
        if (f == null) {
            return false;
        }
        return Objects.requireNonNull(FluidUtil.getFluidHandler((World)world, (BlockPos)pos, null)).drain(1000, false) != null;
    }

    public static boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem((ItemStack)stack);
    }

    public static void processFluidItems(IFluidTank tank, ItemStackHandler fluidItems) {
        ItemStackUtils.fillItemFromTank((ItemStackHandler)fluidItems, (IFluidTank)tank);
    }

    @Override
    protected boolean patch() {
        MethodNode acceptsFluidItem = new MethodNode(4, "acceptsFluidItem", "(Lnet/minecraft/item/ItemStack;)Z", null, null);
        acceptsFluidItem.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        acceptsFluidItem.instructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "acceptsFluidItem", "(Lnet/minecraft/item/ItemStack;)Z", false));
        acceptsFluidItem.instructions.add((AbstractInsnNode)new InsnNode(172));
        this.classNode.methods.add(acceptsFluidItem);
        IFPatcher.LOGGER.info("Pump now accepts fluid items!");
        MethodNode processFluidItems = new MethodNode(4, "processFluidItems", "(Lnet/minecraftforge/items/ItemStackHandler;)V", null, null);
        processFluidItems.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        processFluidItems.instructions.add((AbstractInsnNode)new InsnNode(89));
        String hook = "com/buuz135/industrial/tile/world/FluidPumpTile";
        processFluidItems.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "com/buuz135/industrial/tile/world/FluidPumpTile", "tank", "Lnet/minecraftforge/fluids/IFluidTank;"));
        processFluidItems.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        processFluidItems.instructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "processFluidItems", "(Lnet/minecraftforge/fluids/IFluidTank;Lnet/minecraftforge/items/ItemStackHandler;)V", false));
        processFluidItems.instructions.add((AbstractInsnNode)new InsnNode(177));
        this.classNode.methods.add(processFluidItems);
        IFPatcher.LOGGER.info("Pump now fill fluids to items!");
        InsnList work = this.findMethod((String)"work").instructions;
        work.clear();
        work.add((AbstractInsnNode)new VarInsnNode(25, 0));
        work.add((AbstractInsnNode)new FieldInsnNode(180, "com/buuz135/industrial/tile/world/FluidPumpTile", "tank", "Lnet/minecraftforge/fluids/IFluidTank;"));
        work.add((AbstractInsnNode)new VarInsnNode(25, 0));
        work.add((AbstractInsnNode)new FieldInsnNode(180, "com/buuz135/industrial/tile/world/FluidPumpTile", "fluid", "Ljava/lang/String;"));
        work.add((AbstractInsnNode)new VarInsnNode(25, 0));
        work.add((AbstractInsnNode)new FieldInsnNode(180, "com/buuz135/industrial/tile/world/FluidPumpTile", this.getName("world", "field_145850_b"), "Lnet/minecraft/world/World;"));
        work.add((AbstractInsnNode)new VarInsnNode(25, 0));
        work.add((AbstractInsnNode)new FieldInsnNode(180, "com/buuz135/industrial/tile/world/FluidPumpTile", this.getName("pos", "field_174879_c"), "Lnet/minecraft/util/math/BlockPos;"));
        work.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "beforeWork", "(Lnet/minecraftforge/fluids/IFluidTank;Ljava/lang/String;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", false));
        work.add((AbstractInsnNode)new VarInsnNode(25, 0));
        work.add((AbstractInsnNode)new MethodInsnNode(182, "com/buuz135/industrial/tile/world/FluidPumpTile", this.getName("getBlockType", "func_145838_q"), "()Lnet/minecraft/block/Block;", false));
        work.add((AbstractInsnNode)new VarInsnNode(25, 0));
        work.add((AbstractInsnNode)new MethodInsnNode(182, "com/buuz135/industrial/tile/world/FluidPumpTile", "getWorkingArea", "()Lnet/minecraft/util/math/AxisAlignedBB;", false));
        work.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "work", "(Lnet/minecraft/block/Block;Lnet/minecraft/util/math/AxisAlignedBB;)F", false));
        work.add((AbstractInsnNode)new InsnNode(174));
        IFPatcher.LOGGER.info("Pump now works properly!");
        return true;
    }
}

