/*
 * Decompiled with CFR 0.152.
 */
package mod.icarus.crimsonrevelations.casters.foci;

import mod.icarus.crimsonrevelations.init.CRSoundEvents;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpact;
import thaumcraft.common.lib.potions.PotionBlurredVision;

public class FocusEffectBlindingFlash
extends FocusEffect {
    public Aspect getAspect() {
        return Aspect.LIGHT;
    }

    public String getKey() {
        return "focus.crimsonrevelations.blinding_flash";
    }

    public NodeSetting[] createSettings() {
        return new NodeSetting[]{new NodeSetting("power", "focus.common.power", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(1, 5)), new NodeSetting("duration", "focus.common.duration", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(1, 10))};
    }

    public int getComplexity() {
        return this.getSettingValue("duration") + this.getSettingValue("power") * 3;
    }

    public float getDamageForDisplay(float finalPower) {
        return (3.0f + (float)this.getSettingValue("power")) * finalPower;
    }

    public String getResearch() {
        return "CR_FOCUS_BLINDING_FLASH";
    }

    public boolean execute(RayTraceResult target, Trajectory trajectory, float finalPower, int num) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXFocusPartImpact(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, new String[]{this.getKey()}), new NetworkRegistry.TargetPoint(this.getPackage().world.field_73011_w.getDimension(), target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, 64.0));
        this.getPackage().world.func_184148_a(null, target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, CRSoundEvents.FOCUS_BLINDING_LIGHT_HIT, SoundCategory.PLAYERS, 0.8f, 1.0f + (float)(this.getPackage().world.field_73012_v.nextGaussian() * (double)0.05f));
        if (target.field_72313_a == RayTraceResult.Type.ENTITY && target.field_72308_g != null) {
            int duration = 20 * this.getSettingValue("duration");
            int potency = (int)(1.0f + (float)this.getSettingValue("power") * finalPower / 2.0f);
            if (((EntityLivingBase)target.field_72308_g).func_70662_br()) {
                target.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)(target.field_72308_g != null ? target.field_72308_g : this.getPackage().getCaster()), (Entity)this.getPackage().getCaster()).func_76348_h().func_151518_m(), (float)this.getSettingValue("power") * finalPower * 2.0f);
            } else {
                target.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)(target.field_72308_g != null ? target.field_72308_g : this.getPackage().getCaster()), (Entity)this.getPackage().getCaster()), (float)this.getSettingValue("power") * finalPower * 0.5f);
            }
            if (target.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76440_q, duration, potency));
                ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(PotionBlurredVision.instance, duration, potency));
                if (!(target.field_72308_g instanceof EntityPlayer)) {
                    ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, potency));
                }
            }
        }
        return false;
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), CRSoundEvents.FOCUS_BLINDING_LIGHT_SHOOT, SoundCategory.PLAYERS, 1.2f, 1.0f + caster.field_70170_p.field_73012_v.nextFloat() * 0.1f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        FXGeneric pp = new FXGeneric(world, posX, posY, posZ, velX, velY, velZ);
        int color = 16776421;
        pp.setAlphaF(new float[]{0.0f, 1.0f});
        pp.setGravity(-0.2f);
        pp.setGridSize(64);
        pp.setLoop(true);
        pp.func_187114_a(10 + world.field_73012_v.nextInt(5));
        pp.setParticles(512, 16, 1);
        pp.setRandomMovementScale(0.0025f, 0.0f, 0.0025f);
        pp.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        pp.setScale(new float[]{(float)(5.0 + world.field_73012_v.nextGaussian() * (double)0.2f), 0.1f});
        pp.setSlowDown(0.75);
        pp.setWind(0.001);
        ParticleEngine.addEffect((World)world, (Particle)pp);
    }
}

