/*
 * Decompiled with CFR 0.152.
 */
package mod.icarus.crimsonrevelations.casters.foci;

import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpact;

public class FocusEffectTaintPoison
extends FocusEffect {
    public Aspect getAspect() {
        return Aspect.FLUX;
    }

    public String getKey() {
        return "focus.crimsonrevelations.taint_poison";
    }

    public NodeSetting[] createSettings() {
        return new NodeSetting[]{new NodeSetting("power", "focus.common.power", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(1, 5)), new NodeSetting("duration", "focus.common.double_duration", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(1, 10))};
    }

    public int getComplexity() {
        return this.getSettingValue("duration") + this.getSettingValue("power") * 3;
    }

    public float getDamageForDisplay(float finalPower) {
        return (4.0f + (float)this.getSettingValue("power")) * finalPower;
    }

    public String getResearch() {
        return "CR_FOCUS_TAINT_POISON";
    }

    public boolean execute(RayTraceResult target, Trajectory trajectory, float finalPower, int num) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXFocusPartImpact(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, new String[]{this.getKey()}), new NetworkRegistry.TargetPoint(this.getPackage().world.field_73011_w.getDimension(), target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, 64.0));
        this.getPackage().world.func_184148_a(null, target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, SoundsTC.bubble, SoundCategory.PLAYERS, 0.33f, 0.65f + (float)(this.getPackage().world.field_73012_v.nextGaussian() * (double)0.05f));
        this.getPackage().world.func_184148_a(null, target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, SoundsTC.egscreech, SoundCategory.PLAYERS, 0.2f, 1.5f + (float)(this.getPackage().world.field_73012_v.nextGaussian() * (double)0.1f));
        if (target.field_72313_a == RayTraceResult.Type.ENTITY && target.field_72308_g != null) {
            float damage = this.getDamageForDisplay(finalPower);
            int duration = 40 * this.getSettingValue("duration");
            int potency = (int)(1.0f + (float)this.getSettingValue("power") * finalPower / 4.0f);
            target.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)(target.field_72308_g != null ? target.field_72308_g : this.getPackage().getCaster()), (Entity)this.getPackage().getCaster()).func_76348_h(), damage);
            if (target.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(PotionFluxTaint.instance, duration, potency));
            }
        }
        return false;
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundsTC.bubble, SoundCategory.PLAYERS, 0.33f, 0.9f + caster.field_70170_p.field_73012_v.nextFloat() * 0.1f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        FXGeneric pp = new FXGeneric(world, posX, posY, posZ, velX, velY, velZ);
        int color = 10354925;
        pp.setGravity(-0.2f);
        pp.func_187114_a(10 + world.field_73012_v.nextInt(5));
        pp.setParticles(575, 8, 8);
        pp.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        pp.setSlowDown(0.65);
        pp.setScale(new float[]{(float)((double)0.1f + world.field_73012_v.nextGaussian() * (double)0.2f), 3.0f});
        ParticleEngine.addEffect((World)world, (Particle)pp);
    }
}

