/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.blocks;

import elec332.core.api.client.IIconRegistrar;
import elec332.core.api.client.model.IElecModelBakery;
import elec332.core.api.client.model.IElecQuadBakery;
import elec332.core.api.client.model.IElecTemplateBakery;
import elec332.core.api.client.model.template.IModelTemplate;
import elec332.core.api.client.model.template.IMutableModelTemplate;
import elec332.core.block.AbstractBlock;
import elec332.core.client.model.loading.INoJsonBlock;
import elec332.core.client.model.loading.INoJsonItem;
import elec332.core.inventory.window.IWindowHandler;
import elec332.core.inventory.window.WindowManager;
import elec332.core.util.IBlockStateHelper;
import elec332.core.util.ItemStackHelper;
import elec332.core.world.WorldHelper;
import elec332.craftingtableiv.CraftingTableIV;
import elec332.craftingtableiv.tileentity.TileEntityCraftingTableIV;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCraftingTableIV
extends AbstractBlock
implements INoJsonBlock,
INoJsonItem,
ITileEntityProvider {
    @SideOnly(value=Side.CLIENT)
    private IBakedModel model;
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockCraftingTableIV(ResourceLocation name) {
        super(Material.field_151575_d);
        this.setRegistryName(name);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(IBlockStateHelper.FACING_NORMAL.setDefaultMetaState((Block)this));
        this.func_149713_g(0);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntityCraftingTableIV te = (TileEntityCraftingTableIV)WorldHelper.getTileAt((IBlockAccess)worldIn, (BlockPos)pos);
        for (int i = 0; i < te.getSlots(); ++i) {
            ItemStack stack = te.getStackInSlot(i);
            if (!ItemStackHelper.isStackValid((ItemStack)stack)) continue;
            WorldHelper.dropStack((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public IBakedModel getBlockModel(IBlockState state) {
        return this.model;
    }

    public IBakedModel getItemModel(ItemStack stack, World world, EntityLivingBase entity) {
        return this.model;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, RayTraceResult hit) {
        if (!world.field_72995_K) {
            WindowManager.openWindow((EntityPlayer)player, (IWindowHandler)CraftingTableIV.proxy, (World)world, (BlockPos)pos, (byte)CraftingTableIV.guiID);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(IElecQuadBakery quadBakery, IElecModelBakery modelBakery, IElecTemplateBakery templateBakery) {
        IMutableModelTemplate t = templateBakery.newDefaultBlockTemplate();
        t.setBuiltIn(true);
        this.model = modelBakery.itemModelForTextures((IModelTemplate)t, new TextureAtlasSprite[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerTextures(IIconRegistrar registrar) {
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(IBlockStateHelper.FACING_NORMAL.getProperty(), (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return IBlockStateHelper.FACING_NORMAL.getStateForMeta((Block)this, meta);
    }

    public int func_176201_c(IBlockState state) {
        return IBlockStateHelper.FACING_NORMAL.getMetaForState(state);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return IBlockStateHelper.FACING_NORMAL.createMetaBlockState((Block)this, new IProperty[0]);
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileEntityCraftingTableIV();
    }
}

