/*
 * Decompiled with CFR 0.152.
 */
package meldexun.memoryutil;

import sun.misc.Unsafe;

public enum PrimitiveInfo {
    BYTE(Unsafe.ARRAY_BYTE_BASE_OFFSET, 0L),
    SHORT(Unsafe.ARRAY_SHORT_BASE_OFFSET, 1L),
    INT(Unsafe.ARRAY_INT_BASE_OFFSET, 2L),
    LONG(Unsafe.ARRAY_LONG_BASE_OFFSET, 3L),
    FLOAT(Unsafe.ARRAY_FLOAT_BASE_OFFSET, 2L),
    DOUBLE(Unsafe.ARRAY_DOUBLE_BASE_OFFSET, 3L),
    CHAR(Unsafe.ARRAY_CHAR_BASE_OFFSET, 1L);

    private final long arrayBaseOffset;
    private final long offset;

    private PrimitiveInfo(long arrayBaseOffset, long offset) {
        this.arrayBaseOffset = arrayBaseOffset;
        this.offset = offset;
    }

    public long arrayBaseOffset() {
        return this.arrayBaseOffset;
    }

    public long toByte(long x) {
        return x << (int)this.offset;
    }

    public long fromByte(long x) {
        return x >> (int)this.offset;
    }

    public long convertTo(PrimitiveInfo type, long x) {
        return x << (int)this.offset >> (int)type.offset;
    }
}

