/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron.fluid;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.lib.IFluidExtraInformation;
import pl.asie.charset.lib.misc.FluidBase;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;

public class FluidDyedWater
extends FluidBase
implements IFluidExtraInformation {
    public static final ResourceLocation TEXTURE_STILL = new ResourceLocation("charset:blocks/dyed_water_still");
    public static final ResourceLocation TEXTURE_FLOWING = new ResourceLocation("charset:blocks/dyed_water_flow");

    public FluidDyedWater(String fluidName) {
        super(fluidName, TEXTURE_STILL, TEXTURE_FLOWING);
    }

    public String getUnlocalizedName() {
        return "fluid.charset.dyed_water.name";
    }

    @Nullable
    public FluidStack appendDye(FluidStack stack, EnumDyeColor color) {
        NBTTagList dyes;
        FluidStack newStack;
        if (stack.getFluid() == FluidRegistry.WATER) {
            newStack = new FluidStack((Fluid)this, stack.amount);
        } else if (stack.getFluid() == this) {
            newStack = stack.copy();
        } else {
            return null;
        }
        if (newStack.tag == null) {
            newStack.tag = new NBTTagCompound();
        }
        NBTTagList nBTTagList = dyes = newStack.tag.func_150297_b("dyes", 9) ? (NBTTagList)newStack.tag.func_74781_a("dyes") : new NBTTagList();
        if (dyes.func_74745_c() >= 8) {
            return null;
        }
        if (dyes.func_74745_c() == 1 && ((NBTPrimitive)dyes.func_179238_g(0)).func_150290_f() == color.func_176765_a()) {
            return stack;
        }
        dyes.func_74742_a((NBTBase)new NBTTagByte((byte)color.func_176765_a()));
        newStack.tag.func_74782_a("dyes", (NBTBase)dyes);
        return newStack;
    }

    public int getDyeColor(FluidStack stack) {
        NBTTagCompound tag = stack.tag;
        if (tag == null || !tag.func_150297_b("dyes", 9)) {
            return -1;
        }
        NBTTagList dyes = (NBTTagList)stack.tag.func_74781_a("dyes");
        int[] color = new int[3];
        int scale = 0;
        int count = dyes.func_74745_c();
        if (dyes.func_74745_c() == 0) {
            return -1;
        }
        for (int i = 0; i < count; ++i) {
            float[] colF = EnumDyeColor.func_176764_b((int)((NBTPrimitive)dyes.func_179238_g(i)).func_150290_f()).func_193349_f();
            int[] col = new int[]{(int)(colF[0] * 255.0f), (int)(colF[1] * 255.0f), (int)(colF[2] * 255.0f)};
            scale += Math.max(col[0], Math.max(col[1], col[2]));
            color[0] = color[0] + col[0];
            color[1] = color[1] + col[1];
            color[2] = color[2] + col[2];
        }
        int i1 = color[0] / count;
        int j1 = color[1] / count;
        int k1 = color[2] / count;
        float f3 = (float)scale / (float)count;
        float f4 = Math.max(i1, Math.max(j1, k1));
        i1 = (int)((float)i1 * f3 / f4);
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        return (i1 << 16) + (j1 << 8) + k1;
    }

    public int getColor(FluidStack stack) {
        NBTTagCompound tag = stack.tag;
        if (tag == null || !tag.func_150297_b("dyes", 9)) {
            return -1;
        }
        NBTTagList dyes = tag.func_150295_c("dyes", 1);
        int c = dyes.func_74745_c();
        int alpha = CharsetCraftingCauldron.waterAlpha;
        alpha += (255 - alpha) * c / 8;
        return this.getDyeColor(stack) & 0xFFFFFF | alpha << 24;
    }

    private String toString(int c) {
        EnumDyeColor color = EnumDyeColor.func_176764_b((int)c);
        return I18n.func_74838_a((String)ColorUtils.getLangEntry((String)"charset.color.", (EnumDyeColor)color));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(FluidStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int[] dyeCount = new int[EnumDyeColor.values().length];
        NBTTagCompound tag = stack.tag;
        if (tag != null && tag.func_150297_b("dyes", 9)) {
            int v;
            int i;
            NBTTagList dyes = tag.func_150295_c("dyes", 1);
            int c = dyes.func_74745_c();
            if (c == 1) {
                tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"tip.charset.dyed_water.pure", (Object[])new Object[]{this.toString(((NBTPrimitive)dyes.func_179238_g(0)).func_150290_f())}));
                return;
            }
            for (i = 0; i < c; ++i) {
                int n = v = ((NBTPrimitive)dyes.func_179238_g(i)).func_150290_f();
                dyeCount[n] = dyeCount[n] + 1;
            }
            for (i = 0; i < dyeCount.length; ++i) {
                v = dyeCount[i];
                if (v <= 0) continue;
                String key = "tip.charset.dyed_water.element." + v;
                if (!I18n.func_94522_b((String)key)) {
                    key = "tip.charset.dyed_water.element";
                }
                tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)key, (Object[])new Object[]{this.toString(i), v}));
            }
        }
    }
}

