/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron.recipe;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;
import pl.asie.charset.module.crafting.cauldron.api.CauldronContents;
import pl.asie.charset.module.crafting.cauldron.api.ICauldron;
import pl.asie.charset.module.crafting.cauldron.api.ICauldronRecipe;
import pl.asie.charset.module.crafting.cauldron.fluid.FluidPotion;

public class RecipeTipArrow
implements ICauldronRecipe {
    @Override
    public Optional<CauldronContents> apply(ICauldron cauldron, CauldronContents contents) {
        if (!contents.hasFluidStack() || contents.getFluidStack().getFluid() != CharsetCraftingCauldron.liquidLingeringPotion) {
            return Optional.empty();
        }
        if (contents.getHeldItem().func_190926_b() || contents.getHeldItem().func_77973_b() != Items.field_151032_g) {
            return Optional.empty();
        }
        int amount = 0;
        for (int i = CharsetCraftingCauldron.maxArrowTipMultiplier; i >= 1; --i) {
            if (CharsetCraftingCauldron.waterBottleSize % i != 0) continue;
            amount = CharsetCraftingCauldron.waterBottleSize / i;
            break;
        }
        if (contents.getFluidStack().amount < (amount *= contents.getHeldItem().func_190916_E())) {
            return Optional.empty();
        }
        ItemStack tippedArrow = new ItemStack(Items.field_185167_i, contents.getHeldItem().func_190916_E(), 0);
        FluidPotion.copyToPotionItem(tippedArrow, contents.getFluidStack());
        return Optional.of(new CauldronContents(new FluidStack(contents.getFluidStack(), contents.getFluidStack().amount - amount), tippedArrow));
    }
}

