/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron.recipe;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;
import pl.asie.charset.module.crafting.cauldron.api.CauldronContents;
import pl.asie.charset.module.crafting.cauldron.api.ICauldron;
import pl.asie.charset.module.crafting.cauldron.api.ICauldronRecipe;

public class RecipeWashTippedArrow
implements ICauldronRecipe {
    @Override
    public Optional<CauldronContents> apply(ICauldron cauldron, CauldronContents contents) {
        if (!contents.hasFluidStack()) {
            return Optional.empty();
        }
        ItemStack heldItem = contents.getHeldItem();
        if (contents.getFluidStack().getFluid() == FluidRegistry.WATER && heldItem.func_77973_b() instanceof ItemTippedArrow) {
            int amount = 0;
            for (int i = CharsetCraftingCauldron.maxArrowTipMultiplier; i >= 1; --i) {
                if (CharsetCraftingCauldron.waterBottleSize % i != 0) continue;
                amount = CharsetCraftingCauldron.waterBottleSize / i;
                break;
            }
            if (contents.getFluidStack().amount >= amount) {
                return Optional.of(new CauldronContents(new FluidStack(contents.getFluidStack(), contents.getFluidStack().amount - amount), new ItemStack(Items.field_151032_g, heldItem.func_190916_E(), 0)));
            }
        }
        return Optional.empty();
    }
}

