/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.compression;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.experimental.mechanical.IMechanicalPowerConsumer;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.misc.IItemInsertionEmitter;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.module.crafting.compression.BlockCompressionCrafter;
import pl.asie.charset.module.crafting.compression.CompressionShape;

public class TileCompressionCrafter
extends TileBase
implements ITickable,
IItemInsertionEmitter,
IMechanicalPowerConsumer {
    private final NonNullList<ItemStack> buffer = NonNullList.func_191196_a();
    private double speedIn;
    private double torqueIn;
    protected CompressionShape shape;
    private boolean redstoneLevel;
    private boolean backstuffedClient;

    public boolean isBackstuffed() {
        return !this.buffer.isEmpty();
    }

    protected boolean isBackstuffedClient() {
        return this.backstuffedClient;
    }

    public boolean backstuff(ItemStack stack) {
        if (this.buffer.isEmpty()) {
            this.markBlockForUpdate();
        }
        return this.buffer.add((Object)stack);
    }

    public boolean dropBackstuff(EntityPlayer player, EnumFacing facing) {
        if (this.buffer.isEmpty()) {
            return false;
        }
        Vec3d dropPos = new Vec3d((Vec3i)this.field_174879_c.func_177972_a(facing)).func_72441_c(0.5, 0.5, 0.5);
        for (ItemStack stack : this.buffer) {
            ItemUtils.giveOrSpawnItemEntity((EntityPlayer)player, (World)this.field_145850_b, (Vec3d)dropPos, (ItemStack)stack, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)true);
        }
        this.buffer.clear();
        this.markBlockForUpdate();
        return true;
    }

    public void getDrops(NonNullList<ItemStack> stacks, IBlockState state, int fortune, boolean silkTouch) {
        super.getDrops(stacks, state, fortune, silkTouch);
        stacks.addAll(this.buffer);
    }

    public void func_73660_a() {
        if (this.shape != null) {
            this.shape.tick();
        }
    }

    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        super.readNBTData(compound, isClient);
        boolean bl = this.redstoneLevel = compound.func_74771_c("rs") > 0;
        if (!isClient) {
            this.buffer.clear();
            int i = 0;
            while (compound.func_150297_b("buffer" + i, 10)) {
                this.buffer.add((Object)new ItemStack(compound.func_74775_l("buffer" + i++)));
            }
        } else {
            this.backstuffedClient = compound.func_74767_n("bs");
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        super.writeNBTData(compound, isClient);
        compound.func_74774_a("rs", (byte)(this.redstoneLevel ? 15 : 0));
        if (!isClient) {
            for (int i = 0; i < this.buffer.size(); ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                ((ItemStack)this.buffer.get(i)).func_77955_b(tag);
                compound.func_74782_a("buffer" + i, (NBTBase)tag);
            }
        } else {
            compound.func_74757_a("bs", this.isBackstuffed());
        }
        return compound;
    }

    public void getShape(boolean warn) {
        if (this.shape != null && this.shape.isInvalid()) {
            this.shape = null;
        }
        if (this.shape == null) {
            this.shape = CompressionShape.build(this.field_145850_b, this.field_174879_c);
            if (this.shape == null && warn) {
                new Notice((Object)this, (NotificationComponent)NotificationComponentString.translated((String)"notice.charset.compression.invalid_shape", (NotificationComponent[])new NotificationComponent[0])).sendToAll();
            }
        }
    }

    public void craft(IBlockState state) {
        this.shape.craftBegin(this, (EnumFacing)state.func_177229_b((IProperty)Properties.FACING));
    }

    public boolean isCraftingReady() {
        if (ModCharset.isModuleLoaded((String)"power.mechanical")) {
            return this.torqueIn > 0.0;
        }
        return this.redstoneLevel;
    }

    public double getSpeed() {
        if (ModCharset.isModuleLoaded((String)"power.mechanical")) {
            return this.speedIn;
        }
        return this.redstoneLevel ? 1.0 : 0.0;
    }

    public double getTorque() {
        if (ModCharset.isModuleLoaded((String)"power.mechanical")) {
            return this.torqueIn;
        }
        return this.redstoneLevel ? 1.0 : 0.0;
    }

    private void startCrafting(IBlockState state) {
        if (this.isCraftingReady()) {
            this.getShape(true);
            if (this.shape != null) {
                this.craft(state);
            }
        } else {
            this.getShape(false);
            if (this.shape != null) {
                this.shape.checkPowerLevels(true);
            }
        }
    }

    public void onNeighborChange(IBlockState state) {
        if (!this.field_145850_b.field_72995_K) {
            boolean bl = this.redstoneLevel = this.field_145850_b.func_175651_c(this.field_174879_c, (EnumFacing)state.func_177229_b((IProperty)Properties.FACING)) > 0;
            if (!ModCharset.isModuleLoaded((String)"power.mechanical")) {
                this.startCrafting(state);
            }
        }
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public boolean connectsForItemInsertion(EnumFacing side) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockCompressionCrafter) {
            return state.func_177229_b((IProperty)Properties.FACING) != side;
        }
        return false;
    }

    public boolean isRedstonePowered() {
        return this.redstoneLevel;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (ModCharset.isModuleLoaded((String)"power.mechanical") && capability == Capabilities.MECHANICAL_CONSUMER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (ModCharset.isModuleLoaded((String)"power.mechanical") && capability == Capabilities.MECHANICAL_CONSUMER) {
            return (T)Capabilities.MECHANICAL_CONSUMER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isAcceptingPower() {
        this.getShape(false);
        return this.shape != null;
    }

    public void setForce(double speed, double torque) {
        double oldTorque = this.torqueIn;
        this.speedIn = speed;
        this.torqueIn = torque;
        if (ModCharset.isModuleLoaded((String)"power.mechanical")) {
            this.startCrafting(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
    }
}

