/*
 * Decompiled with CFR 0.152.
 */
package pages.client.gui.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mystlibrary.grammar.GrammarRule;
import mystlibrary.proxy.CommonProxy;
import mystlibrary.symbol.SymbolMetadata;
import mystlibrary.symbol.behavior.BlockStateBehavior;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import pages.client.gui.GuiScreenBlockWriter;
import pages.client.gui.element.generic.GuiElement;
import pages.client.gui.element.generic.GuiElementTab;
import pages.client.gui.element.generic.keyvalidator.IKeyValidator;
import pages.save.SymbolSaver;

public class GuiElementBlockWriterListener
extends GuiElement {
    public GuiScreenBlockWriter listener;

    public GuiElementBlockWriterListener(int id, int x, int y, int width, int height, IKeyValidator validator, List<GuiElement> listeners, GuiScreenBlockWriter listener, Float zLevel) {
        super(id, x, y, width, height, validator, listeners, zLevel.floatValue());
        this.listener = listener;
    }

    @Override
    public void elementChanged(GuiElement element) {
        if (element.id == GuiScreenBlockWriter.ElementIds.BUTTON_SAVE.ordinal()) {
            File file;
            boolean saved;
            SymbolMetadata metadata = new SymbolMetadata();
            metadata.name = new ResourceLocation(this.listener.symbolIdField.getText());
            metadata.cardRank = this.listener.cardRankField.getText().trim().isEmpty() ? null : Integer.valueOf(this.listener.cardRankField.getText());
            metadata.poem = Arrays.asList(this.listener.poemEditor.getWords());
            for (Map.Entry<String, Integer> entry : this.listener.grammarRuleEditor.getEnabledGrammarRules().entrySet()) {
                metadata.grammarRules.add(new GrammarRule(new ResourceLocation(entry.getKey()), entry.getValue(), new ResourceLocation[0]));
            }
            JsonObject behavior = new JsonObject();
            behavior.addProperty("behavior_id", BlockStateBehavior.NAME.toString());
            behavior.addProperty("block_id", this.listener.blockState.func_177230_c().getRegistryName().toString());
            JsonObject properties = new JsonObject();
            for (Map.Entry<String, String> entry : this.listener.propertiesEditor.getProperties()) {
                properties.addProperty(entry.getKey(), entry.getValue());
            }
            behavior.add("properties", (JsonElement)properties);
            if (!this.listener.baseInstabilityField.getText().trim().isEmpty()) {
                behavior.addProperty("instability_base", (Number)Float.valueOf(this.listener.baseInstabilityField.getText()));
            }
            if (!this.listener.exposedInstabilityField.getText().trim().isEmpty()) {
                behavior.addProperty("instability_exposed", (Number)Float.valueOf(this.listener.exposedInstabilityField.getText()));
            }
            JsonObject jsonSymbol = metadata.toJson();
            jsonSymbol.remove("localization");
            jsonSymbol.remove("instability");
            jsonSymbol.add("behavior", (JsonElement)behavior);
            File folder = new File(CommonProxy.configDirectory, "mystcraft" + File.separator + "mystlibrary" + File.separator + "symbols");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (saved = SymbolSaver.saveSymbolToDisk(jsonSymbol, file = new File(CommonProxy.configDirectory, "mystcraft" + File.separator + "mystlibrary" + File.separator + "symbols" + File.separator + metadata.name.func_110623_a().toLowerCase().replace(" ", "_") + ".json"), false)) {
                this.listener.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("message.pages.block_symbol_saved", new Object[]{metadata.name.toString()}));
            } else {
                this.listener.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("message.pages.block_symbol_not_saved", new Object[]{metadata.name.toString()}));
            }
        } else if (element instanceof GuiElementTab) {
            for (GuiElement oneElement : this.listener.elementList.values()) {
                if (!(oneElement instanceof GuiElementTab)) continue;
                oneElement.setEnabled(oneElement.id == element.id);
            }
        }
    }
}

