/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import xaero.common.IXaeroMinimap;
import xaero.common.PlatformContextForge;
import xaero.common.message.MinimapMessage;
import xaero.common.message.MinimapMessageHandler;
import xaero.common.message.PacketConsumerForge;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;

public class MinimapMessageHandlerForge
extends MinimapMessageHandler {
    private final IXaeroMinimap modMain;
    private final PlatformContextForge xaeroHudForge;

    public MinimapMessageHandlerForge(IXaeroMinimap modMain, PlatformContextForge xaeroHudForge) {
        this.modMain = modMain;
        this.xaeroHudForge = xaeroHudForge;
    }

    @Override
    public <T extends MinimapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler) {
        PacketConsumerForge<T> consumer = new PacketConsumerForge<T>(serverHandler, clientHandler);
        if (serverHandler != null) {
            this.xaeroHudForge.getNetwork().registerMessage(consumer, type, index, Side.SERVER);
        }
        if (clientHandler != null) {
            this.xaeroHudForge.getNetwork().registerMessage(consumer, type, index, Side.CLIENT);
        }
    }

    @Override
    public <T extends MinimapMessage<T>> void sendToPlayer(EntityPlayerMP player, T message) {
        this.xaeroHudForge.getNetwork().sendTo(message, player);
    }

    @Override
    public <T extends MinimapMessage<T>> void sendToServer(T message) {
        this.xaeroHudForge.getNetwork().sendToServer(message);
    }
}

