/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.node.options;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.common.misc.ListFactory;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListEntryExpandingOptions;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.entry.EditorListRootEntryFactory;
import xaero.hud.category.ui.entry.widget.EditorButton;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.options.EditorOptionNode;
import xaero.hud.category.ui.node.options.EditorOptionsNode;
import xaero.hud.category.ui.node.tooltip.IEditorDataTooltipSupplier;

public class EditorExpandingOptionsNode<V>
extends EditorOptionsNode<V> {
    protected final List<EditorOptionNode<V>> options;

    protected EditorExpandingOptionsNode(@Nonnull String displayName, @Nonnull EditorOptionNode<V> currentValue, @Nonnull List<EditorOptionNode<V>> options, boolean movable, @Nonnull EditorListRootEntryFactory listEntryFactory, IEditorDataTooltipSupplier tooltipSupplier, EditorOptionsNode.IOptionsNodeIsActiveSupplier isActiveSupplier) {
        super(displayName, movable, listEntryFactory, tooltipSupplier, isActiveSupplier);
        this.options = options;
        this.currentValue = currentValue;
    }

    public boolean onSelected(EditorOptionNode<V> option) {
        this.setCurrentValue(option);
        this.setExpanded(false);
        return true;
    }

    @Override
    public List<EditorNode> getSubNodes() {
        return this.options;
    }

    @Override
    public String getDisplayName() {
        return "";
    }

    public static final class FinalBuilder<V>
    extends Builder<V, FinalBuilder<V>> {
        private FinalBuilder(ListFactory listFactory) {
            super(listFactory);
        }

        public static <V> FinalBuilder<V> begin(ListFactory listFactory) {
            return (FinalBuilder)new FinalBuilder<V>(listFactory).setDefault();
        }

        @Override
        protected EditorOptionsNode<V> buildInternally(EditorOptionNode<V> currentValueData, List<EditorOptionNode<V>> options) {
            return new EditorExpandingOptionsNode<V>(this.displayName, currentValueData, options, this.movable, this.listEntryFactory, this.tooltipSupplier, this.isActiveSupplier);
        }
    }

    public static abstract class Builder<V, B extends Builder<V, B>>
    extends EditorOptionsNode.Builder<V, B> {
        protected final List<EditorOptionNode.Builder<V>> optionBuilders;
        protected final ListFactory listFactory;

        protected Builder(ListFactory listFactory) {
            this.optionBuilders = listFactory.get();
            this.listFactory = listFactory;
        }

        @Override
        public B setDefault() {
            super.setDefault();
            this.optionBuilders.clear();
            return (B)((Builder)this.self);
        }

        @Override
        protected EditorListRootEntry.CenteredEntryFactory getCenteredEntryFactory(final EditorNode data, final EditorNode parent, final int index, final GuiCategoryEditor.SettingRowList rowList) {
            return new EditorListRootEntry.CenteredEntryFactory(){

                @Override
                public EditorListEntry get(int x, int y, int width, int height, EditorListRootEntry root) {
                    EditorExpandingOptionsNode eoData = (EditorExpandingOptionsNode)data;
                    boolean isActive = eoData.getIsActiveSupplier().get(parent, eoData);
                    EditorButton button = new EditorButton(parent, new Supplier<String>(){

                        @Override
                        public String get() {
                            return "";
                        }
                    }, isActive, 216, 20, new EditorButton.PressAction(){

                        @Override
                        public void onPress(EditorButton b) {
                            data.getExpandAction(rowList).run();
                        }
                    }, rowList);
                    return new EditorListEntryExpandingOptions(x, y, width, height, index, rowList, root, button, eoData.getMessageSupplier(), data.getTooltipSupplier(parent));
                }
            };
        }

        public B addOptionBuilderFor(V option) {
            this.optionBuilders.add(EditorOptionNode.Builder.begin().setValue(option));
            return (B)((Builder)this.self);
        }

        public B addOptionBuilder(EditorOptionNode.Builder<V> optionBuilder) {
            this.optionBuilders.add(optionBuilder);
            return (B)((Builder)this.self);
        }

        @Override
        public EditorExpandingOptionsNode<V> build() {
            if (this.listFactory == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return (EditorExpandingOptionsNode)super.build();
        }

        @Override
        protected EditorOptionsNode<V> buildInternally() {
            List options = (List)this.optionBuilders.stream().map(new Function<EditorOptionNode.Builder<V>, EditorOptionNode<V>>(){

                @Override
                public EditorOptionNode<V> apply(EditorOptionNode.Builder<V> b) {
                    return b.build();
                }
            }).collect(new Supplier<List<EditorOptionNode<V>>>(){

                @Override
                public List<EditorOptionNode<V>> get() {
                    return Builder.this.listFactory.get();
                }
            }, new BiConsumer<List<EditorOptionNode<V>>, EditorOptionNode<V>>(){

                @Override
                public void accept(List<EditorOptionNode<V>> l, EditorOptionNode<V> e) {
                    l.add(e);
                }
            }, new BiConsumer<List<EditorOptionNode<V>>, List<EditorOptionNode<V>>>(){

                @Override
                public void accept(List<EditorOptionNode<V>> l1, List<EditorOptionNode<V>> l2) {
                    l1.addAll(l2);
                }
            });
            EditorOptionNode currentValueData = null;
            for (EditorOptionNode optionData : options) {
                if (optionData.getValue() != this.currentValue) continue;
                currentValueData = optionData;
                break;
            }
            if (currentValueData == null) {
                throw new IllegalStateException("current value is not one of the options! " + this.currentValue);
            }
            return this.buildInternally(currentValueData, options);
        }

        protected abstract EditorOptionsNode<V> buildInternally(EditorOptionNode<V> var1, List<EditorOptionNode<V>> var2);
    }
}

