/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.RadarIconModelPartPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.ResolvedFieldModelPartRenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.resolver.RadarIconModelFieldResolver;
import xaero.hud.minimap.radar.icon.creator.render.form.model.resolver.ResolvedFieldModelRootPathListener;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.BuiltInRadarIconDefinitions;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;

public class RadarIconModelPrerenderer {
    private static final Object[] ONE_RENDERER_ARRAY = new Object[1];
    private static final Object[] ONE_OBJECT_ARRAY = new Object[1];
    private final RadarIconModelPartPrerenderer partPrerenderer = new RadarIconModelPartPrerenderer();
    private final ResolvedFieldModelPartRenderer resolvedFieldRenderer = new ResolvedFieldModelPartRenderer();
    private final ResolvedFieldModelRootPathListener modelRootPathListener = new ResolvedFieldModelRootPathListener();
    private ModelRenderer mainPart;

    public ModelRenderer renderModel(ModelBase model, Entity entity, ModelRenderer mainPart, Parameters parameters) {
        this.mainPart = mainPart;
        boolean forceFieldCheck = parameters.forceFieldCheck;
        boolean fullModelIcon = parameters.fullModelIcon;
        RadarIconModelConfig config = parameters.config;
        Object modelRoot = null;
        if (config.modelRootPath != null) {
            modelRoot = this.resolveModelRoot(model, config.modelRootPath, entity);
        }
        if (modelRoot == null) {
            modelRoot = BuiltInRadarIconDefinitions.getModelRoot(model);
        }
        this.setupModelRenderType(parameters.texture, parameters.mrt);
        if (config.modelMainPartFieldAliases != null && !config.modelMainPartFieldAliases.isEmpty()) {
            this.searchAndRenderFields(modelRoot, config.modelMainPartFieldAliases, true, parameters);
        }
        if (!fullModelIcon && !forceFieldCheck && (modelRoot instanceof ModelBiped || modelRoot instanceof ModelQuadruped)) {
            this.renderAgeableListModel((ModelBase)modelRoot, parameters);
            return this.mainPart;
        }
        List<String> hardcodedMainPartAliases = parameters.hardcodedMainPartAliases;
        List<String> hardcodedModelPartsFields = parameters.hardcodedModelPartsFields;
        if (config.modelPartsFields == null) {
            this.searchAndRenderFields(modelRoot, hardcodedMainPartAliases, true, parameters);
        }
        List<String> headPartsFields = hardcodedModelPartsFields;
        if (fullModelIcon) {
            headPartsFields = null;
        } else if (config.modelPartsFields != null) {
            headPartsFields = config.modelPartsFields;
        }
        this.searchAndRenderFields(modelRoot, headPartsFields, false, parameters);
        this.clearModelRenderType();
        return this.mainPart;
    }

    private void renderAgeableListModel(ModelBase modelRoot, Parameters parameters) {
        if (modelRoot instanceof ModelBiped) {
            ModelRenderer headRenderer = ((ModelBiped)modelRoot).field_78116_c;
            ModelRenderer headWearRenderer = ((ModelBiped)modelRoot).field_178720_f;
            this.renderPart(headRenderer, parameters);
            this.renderPart(headWearRenderer, parameters);
            return;
        }
        ModelRenderer headRenderer = ((ModelQuadruped)modelRoot).field_78150_a;
        if (headRenderer == null) {
            return;
        }
        this.renderPart(headRenderer, parameters);
    }

    private void renderPart(ModelRenderer part, Parameters parameters) {
        if (this.mainPart == null) {
            this.mainPart = part;
        }
        this.partPrerenderer.renderPart(part, this.mainPart, parameters);
    }

    private void searchAndRenderFields(Object modelRoot, List<String> filter, boolean justOne, Parameters parameters) {
        this.resolvedFieldRenderer.prepare(justOne, this.mainPart, parameters, this.partPrerenderer);
        RadarIconModelFieldResolver.searchSuperclassFields(modelRoot, filter, this.resolvedFieldRenderer, ONE_RENDERER_ARRAY);
        this.mainPart = this.resolvedFieldRenderer.getMainPart();
    }

    public void setupModelRenderType(int entityTexture, ModelRenderTrace mrt) {
        int blendAlphaSrcFactor = mrt.blendAlphaSrcFactor;
        int blendAlphaDestFactor = mrt.blendAlphaDestFactor;
        if (mrt.blendDestFactor == 1 && mrt.blendSrcFactor != 0) {
            blendAlphaSrcFactor = 0;
            blendAlphaDestFactor = 1;
        }
        GlStateManager.func_179120_a((int)mrt.blendSrcFactor, (int)mrt.blendDestFactor, (int)blendAlphaSrcFactor, (int)blendAlphaDestFactor);
        GlStateManager.func_179135_a((boolean)mrt.colorMaskR, (boolean)mrt.colorMaskG, (boolean)mrt.colorMaskB, (boolean)mrt.colorMaskA);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)mrt.depthMask);
        GlStateManager.func_179143_c((int)(mrt.depthTest ? mrt.depthFunc : 519));
        if (mrt.cullFace) {
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_187407_a((GlStateManager.CullFace)(mrt.cullMode == 1029 ? GlStateManager.CullFace.BACK : (mrt.cullMode == 1028 ? GlStateManager.CullFace.FRONT : GlStateManager.CullFace.FRONT_AND_BACK)));
        GlStateManager.func_179144_i((int)entityTexture);
    }

    public void clearModelRenderType() {
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179097_i();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179129_p();
        GlStateManager.func_179144_i((int)0);
    }

    private Object resolveModelRoot(ModelBase model, ArrayList<ArrayList<String>> rootPath, Entity entity) {
        Object currentChainNode = model;
        for (ArrayList<String> pathStep : rootPath) {
            this.modelRootPathListener.prepare();
            RadarIconModelFieldResolver.searchSuperclassFields(currentChainNode, pathStep, this.modelRootPathListener, ONE_OBJECT_ARRAY);
            currentChainNode = this.modelRootPathListener.getCurrentNode();
            if (currentChainNode != null && !this.modelRootPathListener.failed()) continue;
            MinimapLogs.LOGGER.info(String.format("The following entity icon model root path step couldn't be resolved for %s:", EntityList.func_191301_a((Entity)entity)));
            for (String s : pathStep) {
                MinimapLogs.LOGGER.info(pathStep);
            }
            return null;
        }
        return currentChainNode;
    }

    public RadarIconModelPartPrerenderer getPartPrerenderer() {
        return this.partPrerenderer;
    }

    public static final class Parameters
    extends RadarIconModelPartPrerenderer.Parameters {
        public final RadarIconModelConfig defaultConfig;
        public final int texture;
        public final boolean forceFieldCheck;
        public final boolean fullModelIcon;
        public final List<String> hardcodedMainPartAliases;
        public final List<String> hardcodedModelPartsFields;

        public Parameters(RadarIconModelConfig config, RadarIconModelConfig defaultConfig, int texture, ModelRenderTrace mrt, boolean forceFieldCheck, boolean fullModelIcon, List<String> hardcodedMainPartAliases, List<String> hardcodedModelPartsFields, List<ModelRenderer> renderedDest) {
            super(config, mrt, renderedDest);
            this.defaultConfig = defaultConfig;
            this.texture = texture;
            this.forceFieldCheck = forceFieldCheck;
            this.fullModelIcon = fullModelIcon;
            this.hardcodedMainPartAliases = hardcodedMainPartAliases;
            this.hardcodedModelPartsFields = hardcodedModelPartsFields;
        }
    }
}

