/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import org.lwjgl.opengl.GL11;
import xaero.common.core.IXaeroMinimapModelRenderer;
import xaero.common.exception.OpenGLException;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;

public class EntityRenderTracer {
    public static boolean TRACING_MODEL_RENDERS;
    private Entity tracedEntity;
    private Render<?> tracedEntityRenderer;
    private Class<?> tracedEntityModelClass;
    private List<ModelRenderTrace> traceResultList;
    private ModelRenderTrace lastModelRenderDetected;
    private Field blendStateField;
    private Field colorMaskStateField;
    private Field depthStateField;
    private Field blendStateSrcFactorField;
    private Field blendStateDestFactorField;
    private Field blendStateAlphaSrcFactorField;
    private Field blendStateAlphaDestFactorField;
    private Field colorMaskStateRedField;
    private Field colorMaskStateGreenField;
    private Field colorMaskStateBlueField;
    private Field colorMaskStateAlphaField;
    private Field depthStateFuncField;
    private Field depthStateMaskField;
    private Field depthStateTestField;
    private Field booleanStateCurrentStateField;
    private Field cullStateField;
    private Field cullStateEnabledField;
    private Field cullStateModeField;
    private Field textureStatesField;
    private Field textureStateIdField;
    private Field activeTextureField;
    private Field colorStateField;
    private Field colorStateRedField;
    private Field colorStateGreenField;
    private Field colorStateBlueField;
    private Field colorStateAlphaField;

    public EntityRenderTracer() {
        this.initReflection();
        this.traceResultList = new ArrayList<ModelRenderTrace>();
    }

    public <T extends Entity> List<ModelRenderTrace> trace(T entity, Render<? super T> entityRenderer) {
        TRACING_MODEL_RENDERS = true;
        this.tracedEntity = entity;
        this.tracedEntityRenderer = entityRenderer;
        this.tracedEntityModelClass = null;
        this.traceResultList.clear();
        this.lastModelRenderDetected = null;
        GlStateManager.func_179094_E();
        try {
            entityRenderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            OpenGLException.checkGLError();
        }
        catch (Throwable e) {
            this.traceResultList.clear();
            MinimapLogs.LOGGER.error("Exception when calling the full entity renderer for {} before prerendering the icon.", (Object)EntityList.func_191301_a(entity), (Object)e);
        }
        TRACING_MODEL_RENDERS = false;
        this.tracedEntity = null;
        this.tracedEntityRenderer = null;
        GlStateManager.func_179121_F();
        while (GL11.glGetError() != 0) {
        }
        return this.traceResultList;
    }

    public void onModelRender(ModelBase model, float red, float green, float blue, float alpha) {
        ModelRenderTrace lastModelRenderDetectedBU = this.lastModelRenderDetected;
        this.lastModelRenderDetected = null;
        Object[] TEXTURES = (Object[])Misc.getReflectFieldValue(null, this.textureStatesField);
        int textureId = (Integer)Misc.getReflectFieldValue(TEXTURES[(Integer)Misc.getReflectFieldValue(null, this.activeTextureField)], this.textureStateIdField);
        Object BLEND = Misc.getReflectFieldValue(null, this.blendStateField);
        Object DEPTH = Misc.getReflectFieldValue(null, this.depthStateField);
        Object COLOR_MASK = Misc.getReflectFieldValue(null, this.colorMaskStateField);
        Object CULL = Misc.getReflectFieldValue(null, this.cullStateField);
        int blendSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateSrcFactorField);
        int blendDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateDestFactorField);
        int blendAlphaSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaSrcFactorField);
        int blendAlphaDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaDestFactorField);
        int depthFunc = (Integer)Misc.getReflectFieldValue(DEPTH, this.depthStateFuncField);
        boolean depthTest = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(DEPTH, this.depthStateTestField), this.booleanStateCurrentStateField);
        boolean depthMask = (Boolean)Misc.getReflectFieldValue(DEPTH, this.depthStateMaskField);
        boolean colorMaskR = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateRedField);
        boolean colorMaskG = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateGreenField);
        boolean colorMaskB = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateBlueField);
        boolean colorMaskA = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateAlphaField);
        boolean cullFace = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(CULL, this.cullStateEnabledField), this.booleanStateCurrentStateField);
        int cullMode = (Integer)Misc.getReflectFieldValue(CULL, this.cullStateModeField);
        if (lastModelRenderDetectedBU != null && lastModelRenderDetectedBU.hasProperties(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, cullFace, cullMode)) {
            this.lastModelRenderDetected = lastModelRenderDetectedBU;
            return;
        }
        this.lastModelRenderDetected = new ModelRenderTrace(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, red, green, blue, alpha, cullFace, cullMode);
        this.traceResultList.add(this.lastModelRenderDetected);
    }

    public void onModelPartRender(ModelRenderer modelRenderer) {
        ModelBase model = ((IXaeroMinimapModelRenderer)modelRenderer).getXaero_model();
        if (this.tracedEntityModelClass == null) {
            ModelBase currentMainModel = this.getEntityRendererModel(this.tracedEntityRenderer);
            Class<?> clazz = this.tracedEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
            if (this.tracedEntityModelClass == null) {
                return;
            }
        }
        if (!model.getClass().isAssignableFrom(this.tracedEntityModelClass) && !this.tracedEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        Object COLOR = Misc.getReflectFieldValue(null, this.colorStateField);
        float red = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateRedField)).floatValue();
        float green = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateGreenField)).floatValue();
        float blue = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateBlueField)).floatValue();
        float alpha = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateAlphaField)).floatValue();
        this.onModelRender(model, red, green, blue, alpha);
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    public ModelBase getEntityRendererModel(Render<?> entityRenderer) {
        if (entityRenderer instanceof RenderLivingBase) {
            return ((RenderLivingBase)entityRenderer).func_177087_b();
        }
        return null;
    }

    private void initReflection() {
        this.blendStateField = Misc.getFieldReflection(GlStateManager.class, "blendState", "field_179157_e");
        this.colorMaskStateField = Misc.getFieldReflection(GlStateManager.class, "colorMaskState", "field_179171_s");
        this.depthStateField = Misc.getFieldReflection(GlStateManager.class, "depthState", "field_179154_f");
        this.textureStatesField = Misc.getFieldReflection(GlStateManager.class, "textureState", "field_179174_p");
        this.cullStateField = Misc.getFieldReflection(GlStateManager.class, "cullState", "field_179167_h");
        try {
            Class<?> blendStateClass = Misc.getClassForName("net.minecraft.client.renderer.GlStateManager$BlendState");
            this.blendStateSrcFactorField = Misc.getFieldReflection(blendStateClass, "srcFactor", "field_179211_b");
            this.blendStateDestFactorField = Misc.getFieldReflection(blendStateClass, "dstFactor", "field_179212_c");
            this.blendStateAlphaSrcFactorField = Misc.getFieldReflection(blendStateClass, "srcFactorAlpha", "field_179209_d");
            this.blendStateAlphaDestFactorField = Misc.getFieldReflection(blendStateClass, "dstFactorAlpha", "field_179210_e");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> colorMaskStateClass = Misc.getClassForName("net.minecraft.client.renderer.GlStateManager$ColorMask");
            this.colorMaskStateRedField = Misc.getFieldReflection(colorMaskStateClass, "red", "field_179188_a");
            this.colorMaskStateGreenField = Misc.getFieldReflection(colorMaskStateClass, "green", "field_179186_b");
            this.colorMaskStateBlueField = Misc.getFieldReflection(colorMaskStateClass, "blue", "field_179187_c");
            this.colorMaskStateAlphaField = Misc.getFieldReflection(colorMaskStateClass, "alpha", "field_179185_d");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> depthStateClass = Misc.getClassForName("net.minecraft.client.renderer.GlStateManager$DepthState");
            this.depthStateTestField = Misc.getFieldReflection(depthStateClass, "depthTest", "field_179052_a");
            this.depthStateFuncField = Misc.getFieldReflection(depthStateClass, "depthFunc", "field_179051_c");
            this.depthStateMaskField = Misc.getFieldReflection(depthStateClass, "maskEnabled", "field_179050_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> cullStateClass = Misc.getClassForName("net.minecraft.client.renderer.GlStateManager$CullState");
            this.cullStateEnabledField = Misc.getFieldReflection(cullStateClass, "cullFace", "field_179054_a");
            this.cullStateModeField = Misc.getFieldReflection(cullStateClass, "mode", "field_179053_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> booleanStateClass = Misc.getClassForName("net.minecraft.client.renderer.GlStateManager$BooleanState");
            this.booleanStateCurrentStateField = Misc.getFieldReflection(booleanStateClass, "currentState", "field_179201_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> textureStateClass = Misc.getClassForName("net.minecraft.client.renderer.GlStateManager$TextureState");
            this.textureStateIdField = Misc.getFieldReflection(textureStateClass, "textureName", "field_179059_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.activeTextureField = Misc.getFieldReflection(GlStateManager.class, "activeTextureUnit", "field_179162_o");
        this.colorStateField = Misc.getFieldReflection(GlStateManager.class, "colorState", "field_179170_t");
        try {
            Class<?> colorStateClass = Misc.getClassForName("net.minecraft.client.renderer.GlStateManager$Color");
            this.colorStateRedField = Misc.getFieldReflection(colorStateClass, "red", "field_179195_a");
            this.colorStateGreenField = Misc.getFieldReflection(colorStateClass, "green", "field_179193_b");
            this.colorStateBlueField = Misc.getFieldReflection(colorStateClass, "blue", "field_179194_c");
            this.colorStateAlphaField = Misc.getFieldReflection(colorStateClass, "alpha", "field_179192_d");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }
}

