/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.smoothscrollingeverywhere;

import java.io.File;
import java.util.function.Function;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="smooth-scrolling-everywhere", clientSideOnly=true)
public class SmoothScrollingEverywhere {
    private static Function<Double, Double> easingMethod = v -> v;
    private static Property scrollDuration;
    private static Property scrollStep;
    private static Property bounceBackMultiplier;
    private static Property unlimitFps;
    private static Configuration configuration;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            configuration = new Configuration(new File(event.getModConfigurationDirectory(), "smooth-scrolling-everywhere.cfg"));
            configuration.load();
            scrollDuration = configuration.get("general", "Scroll Duration", 600, null, 0, 5000);
            scrollStep = configuration.get("general", "Scroll Step", 19.0, null, 0.0, 100.0);
            bounceBackMultiplier = configuration.get("general", "Bounce Back Multiplier", 0.24);
            unlimitFps = configuration.get("general", "Unlimit FPS", true, "Unlimit FPS (30 FPS) on title screen.");
            SmoothScrollingEverywhere.getScrollDuration();
            SmoothScrollingEverywhere.getScrollStep();
            SmoothScrollingEverywhere.getBounceBackMultiplier();
            SmoothScrollingEverywhere.isUnlimitFps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static Function<Double, Double> getEasingMethod() {
        return easingMethod;
    }

    public static long getScrollDuration() {
        return scrollDuration == null ? 600L : (long)scrollDuration.getInt();
    }

    public static float getScrollStep() {
        return scrollStep == null ? 19.0f : (float)scrollStep.getDouble();
    }

    public static float getBounceBackMultiplier() {
        return bounceBackMultiplier == null ? 0.24f : (float)bounceBackMultiplier.getDouble();
    }

    public static boolean isUnlimitFps() {
        return unlimitFps != null && unlimitFps.getBoolean();
    }

    public static float handleScrollingPosition(float[] target, float scroll, float maxScroll, float delta, double start, double duration) {
        if (SmoothScrollingEverywhere.getBounceBackMultiplier() >= 0.0f) {
            target[0] = SmoothScrollingEverywhere.clamp(target[0], maxScroll);
            if (target[0] < 0.0f) {
                target[0] = target[0] - target[0] * (1.0f - SmoothScrollingEverywhere.getBounceBackMultiplier()) * delta / 3.0f;
            } else if (target[0] > maxScroll) {
                target[0] = (target[0] - maxScroll) * (1.0f - (1.0f - SmoothScrollingEverywhere.getBounceBackMultiplier()) * delta / 3.0f) + maxScroll;
            }
        } else {
            target[0] = SmoothScrollingEverywhere.clamp(target[0], maxScroll, 0.0f);
        }
        if (!Precision.almostEquals(scroll, target[0], 0.001f)) {
            return SmoothScrollingEverywhere.expoEase(scroll, target[0], Math.min(((double)System.currentTimeMillis() - start) / duration * (double)delta * 3.0, 1.0));
        }
        return target[0];
    }

    public static float expoEase(float start, float end, double amount) {
        return start + (end - start) * SmoothScrollingEverywhere.getEasingMethod().apply(amount).floatValue();
    }

    public static double clamp(double v, double maxScroll) {
        return SmoothScrollingEverywhere.clamp(v, maxScroll, 300.0);
    }

    public static double clamp(double v, double maxScroll, double clampExtension) {
        return MathHelper.func_151237_a((double)v, (double)(-clampExtension), (double)(maxScroll + clampExtension));
    }

    public static float clamp(float v, float maxScroll) {
        return SmoothScrollingEverywhere.clamp(v, maxScroll, 300.0f);
    }

    public static float clamp(float v, float maxScroll, float clampExtension) {
        return MathHelper.func_76131_a((float)v, (float)(-clampExtension), (float)(maxScroll + clampExtension));
    }

    private static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        private Precision() {
        }

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }
}

