/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks;

import com.mojang.authlib.GameProfile;
import griglog.thaumtweaks.TTConfig;
import griglog.thaumtweaks.ThaumTweaks;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.IRechargable;
import thaumcraft.common.items.armor.ItemFortressArmor;
import thaumcraft.common.items.armor.ItemVoidRobeArmor;

public class SF {
    public static void print(String prefix, String text) {
        ThaumTweaks.LOGGER.info("!!!" + prefix + " " + text);
    }

    public static void print(String prefix) {
        SF.print(prefix, "");
    }

    public static void printChat(String s) {
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        TextComponentString msg = new TextComponentString(s);
        chat.func_146227_a((ITextComponent)msg);
    }

    public static FakePlayer getFake(WorldServer w) {
        return new FakePlayer(w, new GameProfile(new UUID(0L, 0L), ""));
    }

    public static void copyKnowledge(Object a, Object b) {
        IPlayerKnowledge aBrains = null;
        IPlayerKnowledge bBrains = null;
        if (a instanceof EntityLivingBase) {
            aBrains = (IPlayerKnowledge)((EntityLivingBase)a).getCapability(ThaumcraftCapabilities.KNOWLEDGE, null);
        } else if (a instanceof TileEntity) {
            aBrains = (IPlayerKnowledge)((TileEntity)a).getCapability(ThaumcraftCapabilities.KNOWLEDGE, null);
        }
        if (b instanceof EntityLivingBase) {
            bBrains = (IPlayerKnowledge)((EntityLivingBase)b).getCapability(ThaumcraftCapabilities.KNOWLEDGE, null);
        } else if (b instanceof TileEntity) {
            bBrains = (IPlayerKnowledge)((TileEntity)b).getCapability(ThaumcraftCapabilities.KNOWLEDGE, null);
        }
        if (aBrains != null && bBrains != null) {
            for (String k : aBrains.getResearchList()) {
                bBrains.addResearch(k);
                bBrains.setResearchStage(k, aBrains.getResearchStage(k));
            }
        }
    }

    public static void spawnItem(World world, ItemStack is, BlockPos pos) {
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, is));
    }

    public static List<String> readFile(String filename, String defaultContents) {
        try {
            Path path = Paths.get(filename, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                FileWriter w = new FileWriter(filename);
                w.write(defaultContents);
                w.close();
            }
            return Files.readAllLines(path);
        }
        catch (IOException e) {
            return Arrays.asList(defaultContents.split("\n"));
        }
    }

    public static int getCount(IItemHandler handler, ItemStack checked) {
        if (handler == null) {
            return 0;
        }
        int slots = handler.getSlots();
        int count = 0;
        for (int i = 0; i < slots; ++i) {
            ItemStack is = handler.getStackInSlot(i);
            if (is.func_77973_b() != checked.func_77973_b() || is.func_77942_o() != checked.func_77942_o() || is.func_77942_o() && !is.func_77978_p().equals((Object)checked.func_77978_p())) continue;
            count += is.func_190916_E();
        }
        return count;
    }

    public static boolean canExtract(IItemHandler handler, ItemStack checked) {
        if (handler == null) {
            return false;
        }
        int slots = handler.getSlots();
        int count = 0;
        for (int i = 0; i < slots; ++i) {
            ItemStack is = handler.getStackInSlot(i);
            if (is.func_77973_b() != checked.func_77973_b() || is.func_77942_o() != checked.func_77942_o() || is.func_77942_o() && !is.func_77978_p().equals((Object)checked.func_77978_p()) || (count += is.func_190916_E()) < checked.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public static int extract(IItemHandler handler, ItemStack extract) {
        if (handler == null) {
            return extract.func_190916_E();
        }
        int slots = handler.getSlots();
        int toExtract = extract.func_190916_E();
        for (int i = 0; i < slots; ++i) {
            ItemStack is = handler.getStackInSlot(i);
            if (is.func_77973_b() != extract.func_77973_b() || is.func_77942_o() != extract.func_77942_o() || is.func_77942_o() && !is.func_77978_p().equals((Object)extract.func_77978_p())) continue;
            int count = is.func_190916_E();
            if (count >= toExtract) {
                handler.extractItem(i, toExtract, false);
                return 0;
            }
            toExtract -= count;
            handler.extractItem(i, count, false);
        }
        return toExtract;
    }

    public static boolean isRechargeable(Item item) {
        if (!(item instanceof IRechargable)) {
            return false;
        }
        if (!TTConfig.general.armor) {
            return false;
        }
        if (TTConfig.fortArmor.vis == 0 && item instanceof ItemFortressArmor) {
            return false;
        }
        return TTConfig.voidRobe.vis != 0 || !(item instanceof ItemVoidRobeArmor);
    }
}

