/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.blocks.crafter.helpers;

import griglog.thaumtweaks.blocks.crafter.TileArcaneCrafter;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ArcaneHandler
implements IItemHandler,
IItemHandlerModifiable {
    TileArcaneCrafter tile;
    IInventory inv;

    public ArcaneHandler(TileEntity t, IInventory inv) {
        this.tile = (TileArcaneCrafter)t;
        this.inv = inv;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            if (slot < this.getSlots() - 1) {
                return this.insertItem(slot + 1, stack, simulate);
            }
            return stack;
        }
        return this.baseInsert(slot, stack, simulate);
    }

    public ItemStack baseInsert(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.inv.func_70301_a(slot);
        int limit = this.getSlotLimit(slot);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.inv.func_70299_a(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
        }
        this.onContentsChanged(slot);
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.inv.func_70301_a(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.inv.func_70299_a(slot, ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.inv.func_70299_a(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.inv.func_70302_i_()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.inv.func_70302_i_() + ")");
        }
    }

    void onContentsChanged(int slot) {
        this.tile.onInventoryUpdate();
    }
}

