/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.entity;

import griglog.thaumtweaks.ThaumTweaks;
import griglog.thaumtweaks.entity.PechType;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thaumcraft.common.entities.monster.EntityPech;

public class PechTradesHelper {
    public static ArrayList<TradeEntry> uninitializedTrades = new ArrayList();

    public static void tryAddEntries(TradeEntry e, int amount) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(e.id));
        if (item == null) {
            for (int i = 0; i < amount; ++i) {
                uninitializedTrades.add(e);
            }
            return;
        }
        for (int i = 0; i < amount; ++i) {
            PechTradesHelper.addEntry(e, item);
        }
    }

    static void addEntry(TradeEntry e, Item parsedItem) {
        ItemStack is;
        ItemStack itemStack = is = e.meta == -1 ? new ItemStack(parsedItem) : new ItemStack(parsedItem, 1, e.meta);
        if (!e.tag.equals("")) {
            try {
                is.func_77982_d(JsonToNBT.func_180713_a((String)e.tag));
            }
            catch (NBTException error) {
                error.printStackTrace();
            }
        }
        if (e.type.equals((Object)PechType.COMMON)) {
            ((ArrayList)EntityPech.tradeInventory.get(PechType.MINER.ordinal())).add(Arrays.asList(e.tier, is));
            ((ArrayList)EntityPech.tradeInventory.get(PechType.MAGE.ordinal())).add(Arrays.asList(e.tier, is));
            ((ArrayList)EntityPech.tradeInventory.get(PechType.ARCHER.ordinal())).add(Arrays.asList(e.tier, is));
        } else {
            ((ArrayList)EntityPech.tradeInventory.get(e.type.ordinal())).add(Arrays.asList(e.tier, is));
        }
    }

    public static void addUninitialized() {
        for (TradeEntry e : uninitializedTrades) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(e.id));
            if (item == null) {
                ThaumTweaks.LOGGER.error(String.format("Item \"%s\" does not exist!", e.id));
                return;
            }
            PechTradesHelper.addEntry(e, item);
        }
        uninitializedTrades.clear();
    }

    public static class TradeEntry {
        int meta;
        int tier;
        PechType type;
        String id;
        String tag;

        public TradeEntry(PechType type, int tier, String id, int meta, String tag) {
            this.meta = meta;
            this.tier = tier;
            this.type = type;
            this.id = id;
            this.tag = tag;
        }
    }
}

