/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.events;

import griglog.thaumtweaks.TTConfig;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.utils.BlockUtils;

@Mod.EventBusSubscriber
public class ToolEvents {
    public static HashMap<Integer, EnumFacing> lastFaceClicked;
    static boolean blocksBreaking;

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (player == null || player.func_184600_cs() == null) {
            return;
        }
        ItemStack heldItem = player.func_184586_b(player.func_184600_cs());
        if (heldItem.func_77977_a().equals(ItemsTC.primalCrusher.func_77658_a()) && !blocksBreaking && !player.func_70093_af()) {
            blocksBreaking = true;
            EnumFacing facing = lastFaceClicked.get(event.getHarvester().func_145782_y());
            if (facing == null) {
                facing = EnumFacing.func_190914_a((BlockPos)event.getPos(), (EntityLivingBase)event.getHarvester());
            }
            if (TTConfig.tools.zone_5) {
                ToolEvents.mineExtended(facing, event, heldItem);
            } else {
                ToolEvents.mineUsual(facing, event, heldItem);
            }
            blocksBreaking = false;
        }
    }

    private static void mineUsual(EnumFacing facing, BlockEvent.HarvestDropsEvent event, ItemStack heldItem) {
        switch (facing) {
            case UP: 
            case DOWN: {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        ToolEvents.tryBreakBlock(event, x, 0, z, heldItem);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        ToolEvents.tryBreakBlock(event, x, y, 0, heldItem);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        ToolEvents.tryBreakBlock(event, 0, y, z, heldItem);
                    }
                }
                break;
            }
        }
    }

    static void mineExtended(EnumFacing facing, BlockEvent.HarvestDropsEvent event, ItemStack heldItem) {
        switch (facing) {
            case UP: 
            case DOWN: {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        ToolEvents.tryBreakBlock(event, x, 0, z, heldItem);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 3; ++y) {
                        ToolEvents.tryBreakBlock(event, x, y, 0, heldItem);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int z = -2; z <= 2; ++z) {
                    for (int y = -1; y <= 3; ++y) {
                        ToolEvents.tryBreakBlock(event, 0, y, z, heldItem);
                    }
                }
                break;
            }
        }
    }

    static void tryBreakBlock(BlockEvent.HarvestDropsEvent event, int xx, int yy, int zz, ItemStack heldItem) {
        IBlockState bl = event.getWorld().func_180495_p(event.getPos().func_177982_a(xx, yy, zz));
        if (bl.func_185887_b(event.getWorld(), event.getPos().func_177982_a(xx, yy, zz)) >= 0.0f && (ForgeHooks.isToolEffective((IBlockAccess)event.getWorld(), (BlockPos)event.getPos().func_177982_a(xx, yy, zz), (ItemStack)heldItem) || heldItem.func_77973_b() instanceof ItemTool && ((ItemTool)heldItem.func_77973_b()).func_150893_a(heldItem, bl) > 1.0f)) {
            heldItem.func_77972_a(1, (EntityLivingBase)event.getHarvester());
            BlockUtils.harvestBlock((World)event.getWorld(), (EntityPlayer)event.getHarvester(), (BlockPos)event.getPos().func_177982_a(xx, yy, zz));
        }
    }

    static {
        try {
            Field f = thaumcraft.common.lib.events.ToolEvents.class.getDeclaredField("lastFaceClicked");
            f.setAccessible(true);
            lastFaceClicked = (HashMap)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        blocksBreaking = false;
    }
}

