/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.mixins.armor;

import com.google.common.collect.Multimap;
import griglog.thaumtweaks.TTConfig;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.common.items.armor.ItemFortressArmor;

@Mixin(value={ItemFortressArmor.class})
public abstract class FortressArmorMixin
extends ItemArmor
implements IRechargable {
    public FortressArmorMixin(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap attrib = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77658_a() + slot.toString()).hashCode(), 0L);
        if (slot == this.field_77881_a) {
            attrib.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid, "Fortress armor modifier " + this.field_77881_a, slot == EntityEquipmentSlot.CHEST ? 0.4 : 0.3, 0));
        }
        return attrib;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        super.onArmorTick(world, player, armor);
        if (TTConfig.general.armor && !world.field_72995_K && player.field_70173_aa % 100 == 0 && this.hasSet(player)) {
            this.addStrength(player);
        }
    }

    @Inject(method={"getProperties"}, remap=false, cancellable=true, at={@At(value="HEAD")})
    void getProps(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot, CallbackInfoReturnable<ISpecialArmor.ArmorProperties> ci) {
        if (!TTConfig.general.armor) {
            return;
        }
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(0, 0.0, armor.func_77958_k() + 1 - armor.func_77952_i());
        if (player instanceof EntityPlayer) {
            int q = 0;
            for (int a = 1; a < 4; ++a) {
                ItemStack piece = (ItemStack)((EntityPlayer)player).field_71071_by.field_70460_b.get(a);
                if (piece.func_190926_b() || !(piece.func_77973_b() instanceof ItemFortressArmor)) continue;
                if (piece.func_77942_o() && piece.func_77978_p().func_74764_b("mask")) {
                    ap.Armor += 1.0;
                }
                if (++q > 1) continue;
                ap.Armor += 1.0;
                ap.Toughness += 1.0;
            }
        }
        int priority = 0;
        double ratio = ((double)this.field_77879_b + ap.Armor) * TTConfig.fortArmor.ratio / 19.0;
        if (source.func_82725_o()) {
            priority = 1;
            ratio = ((double)this.field_77879_b + ap.Armor) * TTConfig.fortArmor.magicRatio / 19.0;
        } else if (!source.func_76347_k() && !source.func_94541_c() && source.func_76363_c()) {
            priority = 0;
            ratio = 0.0;
        }
        ap.AbsorbRatio = ratio += this.tryAddRatio(player, armor, damage);
        ap.Priority = priority;
        ci.setReturnValue((Object)ap);
    }

    void addStrength(EntityPlayer player) {
        if (TTConfig.fortArmor.str > 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 100, TTConfig.fortArmor.str - 1));
        }
    }

    boolean hasSet(EntityPlayer player) {
        for (int i = 1; i < 4; ++i) {
            ItemStack slot = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (!slot.func_190926_b() && slot.func_77973_b() instanceof ItemFortressArmor) continue;
            return false;
        }
        return true;
    }

    double tryAddRatio(EntityLivingBase entity, ItemStack is, double damage) {
        EntityPlayer player = (EntityPlayer)entity;
        if (player == null) {
            return 0.0;
        }
        if ((double)RechargeHelper.getChargePercentage((ItemStack)is, (EntityPlayer)player) > 0.7 && RechargeHelper.consumeCharge((ItemStack)is, (EntityLivingBase)player, (int)Math.round((float)(Math.log(Math.max(damage, 1.0)) / Math.log(TTConfig.fortArmor.logBase))))) {
            return TTConfig.fortArmor.protec;
        }
        return 0.0;
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return TTConfig.general.armor;
    }

    public int getMaxCharge(ItemStack var1, EntityLivingBase var2) {
        return TTConfig.general.armor ? TTConfig.fortArmor.vis : 0;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack var1, EntityLivingBase var2) {
        return IRechargable.EnumChargeDisplay.NORMAL;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        int q = 0;
        int ar = 0;
        for (int a = 1; a < 4; ++a) {
            ItemStack piece = (ItemStack)player.field_71071_by.field_70460_b.get(a);
            if (piece.func_190926_b() || !(piece.func_77973_b() instanceof ItemFortressArmor)) continue;
            if (piece.func_77942_o() && piece.func_77978_p().func_74764_b("mask")) {
                ++ar;
            }
            if (++q > 1) continue;
            ++ar;
        }
        return ar;
    }
}

