/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.mixins.armor;

import com.google.common.collect.Multimap;
import griglog.thaumtweaks.TTConfig;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.common.items.armor.ItemVoidRobeArmor;

@Mixin(value={ItemVoidRobeArmor.class})
public abstract class VoidRobeMixin
extends ItemArmor
implements IRechargable {
    public VoidRobeMixin(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K && stack.func_77951_h() && entity.field_70173_aa % 20 == 0 && entity instanceof EntityLivingBase) {
            stack.func_77972_a(TTConfig.general.armor ? -4 : -1, (EntityLivingBase)entity);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        super.onArmorTick(world, player, armor);
        if (!TTConfig.general.armor) {
            return;
        }
        if (!world.field_72995_K && this.hasSet(player)) {
            if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
                if (player.field_70173_aa % 60 == 0) {
                    this.tryFeed(player, armor);
                }
            } else if (this.field_77881_a == EntityEquipmentSlot.CHEST) {
                if (player.field_70173_aa % 20 == 0) {
                    this.tryHeal(player, armor);
                }
            } else if (this.field_77881_a == EntityEquipmentSlot.LEGS && player.field_70173_aa % 40 == 0) {
                this.clearDebuffs(player, armor);
            }
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap attrib = super.getAttributeModifiers(slot, stack);
        if (TTConfig.general.armor) {
            UUID uuid = new UUID((this.func_77658_a() + slot.toString()).hashCode(), 0L);
            if (slot == this.field_77881_a) {
                attrib.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid, "Void robe modifier " + this.field_77881_a, 0.25, 0));
            }
        }
        return attrib;
    }

    @Inject(method={"getProperties"}, remap=false, cancellable=true, at={@At(value="HEAD")})
    void getProps(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot, CallbackInfoReturnable<ISpecialArmor.ArmorProperties> ci) {
        if (!TTConfig.general.armor) {
            return;
        }
        int priority = 0;
        double ratio = (double)this.field_77879_b * TTConfig.voidRobe.ratio / 20.0;
        if (source.func_82725_o() || source.func_76363_c()) {
            priority = 1;
            ratio = (double)this.field_77879_b * TTConfig.voidRobe.magicRatio / 20.0;
        }
        ci.setReturnValue((Object)new ISpecialArmor.ArmorProperties(priority, ratio += this.tryAddRatio(player, armor, damage), armor.func_77958_k() + 1 - armor.func_77952_i()));
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return TTConfig.general.armor;
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player) {
        return TTConfig.general.armor ? (this.field_77881_a == EntityEquipmentSlot.HEAD ? 8 : 7) : 5;
    }

    public int getMaxCharge(ItemStack var1, EntityLivingBase var2) {
        return TTConfig.general.armor ? TTConfig.voidRobe.vis : 0;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack var1, EntityLivingBase var2) {
        return IRechargable.EnumChargeDisplay.NORMAL;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    void clearDebuffs(EntityPlayer player, ItemStack is) {
        if (player.func_70660_b(MobEffects.field_82731_v) != null && RechargeHelper.consumeCharge((ItemStack)is, (EntityLivingBase)player, (int)TTConfig.voidRobe.clearVis)) {
            player.func_184589_d(MobEffects.field_82731_v);
        }
        if (player.func_70660_b(MobEffects.field_76436_u) != null && RechargeHelper.consumeCharge((ItemStack)is, (EntityLivingBase)player, (int)TTConfig.voidRobe.clearVis)) {
            player.func_184589_d(MobEffects.field_76436_u);
        }
        if (player.func_70660_b(PotionFluxTaint.instance) != null && RechargeHelper.consumeCharge((ItemStack)is, (EntityLivingBase)player, (int)TTConfig.voidRobe.clearVis)) {
            player.func_184589_d(PotionFluxTaint.instance);
        }
    }

    void tryHeal(EntityPlayer player, ItemStack is) {
        if (player.func_110143_aJ() < player.func_110138_aP() && RechargeHelper.consumeCharge((ItemStack)is, (EntityLivingBase)player, (int)((int)(TTConfig.voidRobe.heal * (double)TTConfig.voidRobe.healVis)))) {
            player.func_70691_i((float)TTConfig.voidRobe.heal);
        }
    }

    void tryFeed(EntityPlayer player, ItemStack is) {
        if (TTConfig.voidRobe.canFeed && player.func_71043_e(false) && RechargeHelper.consumeCharge((ItemStack)is, (EntityLivingBase)player, (int)TTConfig.voidRobe.feedVis)) {
            player.func_71024_bL().func_75122_a(1, 0.3f);
        }
    }

    double tryAddRatio(EntityLivingBase entity, ItemStack is, double damage) {
        EntityPlayer player = (EntityPlayer)entity;
        if (player == null) {
            return 0.0;
        }
        if ((double)RechargeHelper.getChargePercentage((ItemStack)is, (EntityPlayer)player) > 0.75 && RechargeHelper.consumeCharge((ItemStack)is, (EntityLivingBase)player, (int)Math.round((float)(Math.log(Math.max(damage, 1.0)) / Math.log(TTConfig.voidRobe.logBase))))) {
            return TTConfig.voidRobe.protec;
        }
        return 0.0;
    }

    boolean hasSet(EntityPlayer player) {
        for (int i = 1; i < 4; ++i) {
            ItemStack slot = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (!slot.func_190926_b() && slot.func_77973_b() instanceof ItemVoidRobeArmor) continue;
            return false;
        }
        return true;
    }
}

