/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.mixins.blocks;

import griglog.thaumtweaks.TTConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.TileThaumcraft;
import thaumcraft.common.tiles.crafting.TileVoidSiphon;

@Mixin(value={TileVoidSiphon.class})
public abstract class SiphonMixin
extends TileThaumcraft {
    private static final int cap = (int)(2000.0 / (TTConfig.voidSiphon.allow ? TTConfig.voidSiphon.speed : 1.0));
    private static final double reduceChance = 0.03 / (TTConfig.voidSiphon.allow ? TTConfig.voidSiphon.endurance : 1.0);
    @Shadow(remap=false)
    int counter;
    @Shadow(remap=false)
    public int progress;

    @Inject(method={"update"}, cancellable=true, at={@At(value="INVOKE", target="Lthaumcraft/common/tiles/TileThaumcraftInventory;update()V", shift=At.Shift.AFTER)})
    public void update(CallbackInfo ci) {
        TileVoidSiphon thisRuntime = (TileVoidSiphon)this;
        ++this.counter;
        if (!this.func_145831_w().field_72995_K && BlockStateUtils.isEnabled((int)this.func_145832_p()) && this.counter % 20 == 0 && this.progress < cap && this.notFull(thisRuntime)) {
            List<EntityFluxRift> rifts = this.getValidRifts();
            boolean b = false;
            for (EntityFluxRift fr : rifts) {
                double speed = Math.sqrt(fr.getRiftSize());
                this.progress = (int)((double)this.progress + speed);
                fr.setRiftStability((float)((double)fr.getRiftStability() - speed / 15.0));
                if (this.field_145850_b.field_73012_v.nextDouble() < reduceChance) {
                    fr.setRiftSize(fr.getRiftSize() - 1);
                }
                b = speed >= 1.0;
            }
            if (b && this.counter % 40 == 0) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 5, this.counter);
            }
            if (this.progress >= cap && this.notFull(thisRuntime)) {
                b = true;
                this.progress -= cap;
                if (this.field_145850_b.field_73012_v.nextInt(24) == 0) {
                    this.tryAddItem(new ItemStack(ItemsTC.curio, 1, 3), thisRuntime);
                } else {
                    this.tryAddItem(new ItemStack(ItemsTC.voidSeed), thisRuntime);
                }
            }
            if (b) {
                this.syncTile(false);
                this.func_70296_d();
            }
        }
        ci.cancel();
    }

    private void tryAddItem(ItemStack is, TileVoidSiphon thisRuntime) {
        if (thisRuntime.func_70301_a(0).func_190926_b()) {
            thisRuntime.func_70299_a(0, is);
        } else if (thisRuntime.func_70301_a(0).func_77973_b() == is.func_77973_b()) {
            thisRuntime.func_70301_a(0).func_190920_e(thisRuntime.func_70301_a(0).func_190916_E() + 1);
        }
    }

    private boolean notFull(TileVoidSiphon thisRuntime) {
        return thisRuntime.func_70301_a(0).func_190926_b() || thisRuntime.func_70301_a(0).func_77973_b() == ItemsTC.voidSeed && thisRuntime.func_70301_a(0).func_190916_E() < thisRuntime.func_70301_a(0).func_77976_d();
    }

    @Shadow(remap=false)
    private List<EntityFluxRift> getValidRifts() {
        return new ArrayList<EntityFluxRift>();
    }
}

