/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.mixins.entities;

import griglog.thaumtweaks.SF;
import griglog.thaumtweaks.TTConfig;
import griglog.thaumtweaks.entity.PechTradesHelper;
import griglog.thaumtweaks.entity.PechType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.Thaumcraft;
import thaumcraft.common.config.ConfigEntities;
import thaumcraft.common.entities.EntityFallingTaint;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.entities.EntityFollowingItem;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.entities.construct.EntityArcaneBore;
import thaumcraft.common.entities.construct.EntityTurretCrossbow;
import thaumcraft.common.entities.construct.EntityTurretCrossbowAdvanced;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.EntityEldritchCrab;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.EntityFireBat;
import thaumcraft.common.entities.monster.EntityGiantBrainyZombie;
import thaumcraft.common.entities.monster.EntityInhabitedZombie;
import thaumcraft.common.entities.monster.EntityMindSpider;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntitySpellBat;
import thaumcraft.common.entities.monster.EntityThaumicSlime;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;
import thaumcraft.common.entities.monster.boss.EntityEldritchWarden;
import thaumcraft.common.entities.monster.boss.EntityTaintacleGiant;
import thaumcraft.common.entities.monster.cult.EntityCultistCleric;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.entities.monster.cult.EntityCultistPortalLesser;
import thaumcraft.common.entities.monster.tainted.EntityTaintCrawler;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeed;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeedPrime;
import thaumcraft.common.entities.monster.tainted.EntityTaintSwarm;
import thaumcraft.common.entities.monster.tainted.EntityTaintacle;
import thaumcraft.common.entities.monster.tainted.EntityTaintacleSmall;
import thaumcraft.common.entities.projectile.EntityAlumentum;
import thaumcraft.common.entities.projectile.EntityBottleTaint;
import thaumcraft.common.entities.projectile.EntityCausalityCollapser;
import thaumcraft.common.entities.projectile.EntityEldritchOrb;
import thaumcraft.common.entities.projectile.EntityFocusCloud;
import thaumcraft.common.entities.projectile.EntityFocusMine;
import thaumcraft.common.entities.projectile.EntityFocusProjectile;
import thaumcraft.common.entities.projectile.EntityGolemDart;
import thaumcraft.common.entities.projectile.EntityGolemOrb;
import thaumcraft.common.entities.projectile.EntityGrapple;
import thaumcraft.common.golems.EntityThaumcraftGolem;

@Mixin(value={ConfigEntities.class})
public abstract class EntityConfigMixin {
    private static final String TWEAKED_TRADES = "MINER:\n\t1:\n\tthaumcraft:cluster:0 //iron\n\tthaumcraft:cluster:1 //gold\n\tthaumcraft:cluster:2 //copper\n\tthaumcraft:cluster:3 //tin\n\tthaumcraft:cluster:4 //silver\n\tthaumcraft:cluster:5 //lead\n\tthaumcraft:cluster:6 //cinnabar\n\tthaumcraft:cluster:7 //quartz\n\t2:\n\tthaumcraft:sapling_greatwood\n\tthaumcraft:thaumium_pick\n\tthaumcraft:thaumium_axe\n\tthaumcraft:thaumium_hoe\n\tminecraft:compass\n\t3:\n\tminecraft:blaze_rod\n\t4:\n\tthaumcraft:sapling_silverwood\n\t5:\n\tminecraft:totem_of_undying\nMAGE:\n\t1:\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"aer\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"terra\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"ignis\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"aqua\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"perditio\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"ordo\"}]}\n\t2:\n\tminecraft:potion {Potion:\"minecraft:regeneration\"} //vanilla TC uses 1.8 metadata numbers, resulting in \"uncraftable potions\"\n\tminecraft:potion {Potion:\"minecraft:healing\"}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"vitium\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"auram\"}]}\n\tthaumcraft:cloth_chest\n\tthaumcraft:cloth_legs\n\tthaumcraft:cloth_boots\n\t3:\n\t4:\n\tthaumcraft:amulet_vis:0\n\t5:\n\tthaumcraft:pech_wand\nARCHER:\n\t1:\n\tthaumcraft:candle_white\n\tthaumcraft:candle_orange\n\tthaumcraft:candle_magenta\n\tthaumcraft:candle_lightblue\n\tthaumcraft:candle_yellow\n\tthaumcraft:candle_lime\n\tthaumcraft:candle_pink\n\tthaumcraft:candle_gray\n\tthaumcraft:candle_silver\n\tthaumcraft:candle_cyan\n\tthaumcraft:candle_purple\n\tthaumcraft:candle_blue\n\tthaumcraft:candle_brown\n\tthaumcraft:candle_green\n\tthaumcraft:candle_red\n\tthaumcraft:candle_black\n\t2:\n\tminecraft:enchanted_book {StoredEnchantments:[{lvl: 1s, id: 50s}]} //Flame\n\tminecraft:enchanted_book {StoredEnchantments:[{lvl: 3s, id: 48s}]} //Powers\n\t3:\n\tminecraft:dragon_breath\n\t4:\n\tminecraft:ghast_tear\n\tthaumcraft:baubles:3 //Apprentice Ring\n\t5:\n\tminecraft:enchanted_book {StoredEnchantments:[{lvl: 1s, id: 51s}]} //Infinity\n\tminecraft:enchanted_book {StoredEnchantments:[{lvl: 5s, id: 48s}]} //Power\nCOMMON:\n\t3:\n\tminecraft:experience_bottle 5\n\tminecraft:golden_apple:0 2\n\tthaumcraft:curio:4\n\t4:\n\tthaumcraft:curio:4 3\n\t5:\n\tminecraft:golden_apple:1\n\tthaumcraft:curio:4 5\n\n#parsing ends with a line starting with #, everything below is a comment. \nThe format of this file is quite obvious, <item> [tag] [weight]. I just want to specify that \n1) its not recommended to make weight too high as it just multiplies the same entry several times\n2) rarity can be from 1 to 5 and nothing else.\nI have placed vanilla TC pech trades here, for the reference.\n\n\n\n\nMINER:\n\t1:\n\tthaumcraft:cluster:0 //iron\n\tthaumcraft:cluster:1 //gold\n\tthaumcraft:cluster:2 //copper\n\tthaumcraft:cluster:3 //tin\n\tthaumcraft:cluster:4 //silver\n\tthaumcraft:cluster:5 //lead\n\tthaumcraft:cluster:6 //cinnabar\n\tthaumcraft:cluster:7 //quartz\n\t2:\n\tminecraft:blaze_rod\n\tminecraft:dragon_breath\n\tminecraft:compass\n\tthaumcraft:sapling_greatwood\t\n\t3:\n\tminecraft:experience_bottle 2\n\tminecraft:golden_apple:0\n\t4:\n\tminecraft:spectral_arrow\n\tthaumcraft:thaumium_pick\n\tthaumcraft:thaumium_axe\n\tthaumcraft:thaumium_hoe\n\t5:\n\tminecraft:golden_apple:1\n\tthaumcraft:curio:4\t\n\tminecraft:totem_of_undying\nMAGE:\n\t1:\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"aer\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"terra\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"ignis\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"aqua\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"perditio\"}]}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"ordo\"}]}\n\t2:\n\tminecraft:potion {Potion:\"minecraft:regeneration\"} //vanilla TC uses 1.8 metadata numbers, resulting in \"uncraftable potions\"\n\tminecraft:potion {Potion:\"minecraft:healing\"}\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"vitium\"}]}\n\t3:\n\tminecraft:experience_bottle 2\n\tminecraft:golden_apple:0\n\tthaumcraft:crystal_essence {Aspects:[{amount:1,key:\"auram\"}]}\n\t4:\n\tthaumcraft:cloth_chest\n\tthaumcraft:cloth_legs\n\tthaumcraft:cloth_boots\n\t5:\n\tminecraft:golden_apple:1\n\tthaumcraft:curio:4\n\tthaumcraft:pech_wand\n\tthaumcraft:amulet_vis:0\nARCHER:\n\t1:\n\tthaumcraft:candle_white\n\tthaumcraft:candle_orange\n\tthaumcraft:candle_magenta\n\tthaumcraft:candle_lightblue\n\tthaumcraft:candle_yellow\n\tthaumcraft:candle_lime\n\tthaumcraft:candle_ping\n\tthaumcraft:candle_gray\n\tthaumcraft:candle_silver\n\tthaumcraft:candle_cyan\n\tthaumcraft:candle_purple\n\tthaumcraft:candle_blue\n\tthaumcraft:candle_brown\n\tthaumcraft:candle_green\n\tthaumcraft:candle_red\n\tthaumcraft:candle_black\n\t2:\n\tminecraft:ghast_tear\n\tminecraft:enchanted_book {StoredEnchantments:[{lvl: 1s, id: 48s}]} //Power\n\t3:\n\tminecraft:experience_bottle 2\n\tminecraft:golden_apple:0\n\t4:\n\tminecraft:golden_apple:1\n\t5:\n\tthaumcraft:curio:4\n\tthaumcraft:baubles:3 //Apprentice Ring\n\tminecraft:enchanted_book {StoredEnchantments:[{lvl: 1s, id: 50s}]} //Flame\n\tminecraft:enchanted_book {StoredEnchantments:[{lvl: 1s, id: 51s}]} //Infinity\n";

    @Inject(method={"initEntities"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void initEntitiesHandler(IForgeRegistry<EntityEntry> iForgeRegistry, CallbackInfo ci) {
        if (!TTConfig.general.pechs) {
            return;
        }
        EntityConfigMixin.otherEntitiesStuff();
        EntityPech.tradeInventory.put(0, new ArrayList());
        EntityPech.tradeInventory.put(1, new ArrayList());
        EntityPech.tradeInventory.put(2, new ArrayList());
        EntityPech.valuedItems.put(Item.func_150891_b((Item)Items.field_151079_bi), 15);
        List<String> file = SF.readFile("config/thaumtweaks_pech_trades.txt", TWEAKED_TRADES);
        PechType pechType = null;
        int tier = -1;
        for (String line : file) {
            if (line.trim().equals("")) continue;
            if (line.startsWith("#")) break;
            if (line.equals("MINER:") || line.equals("MAGE:") || line.equals("ARCHER:") || line.equals("COMMON:")) {
                pechType = PechType.valueOf(line.substring(0, line.length() - 1));
                continue;
            }
            if (line.endsWith(":")) {
                tier = Integer.parseInt(line.substring(line.length() - 2, line.length() - 1));
                continue;
            }
            line = line.split("//")[0].trim();
            String[] parts = line.split(" ");
            String id = parts[0];
            String tag = "";
            int amount = 1;
            if (parts.length >= 2) {
                try {
                    amount = Integer.parseInt(parts[parts.length - 1]);
                    tag = String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length - 1));
                }
                catch (NumberFormatException e) {
                    tag = String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length));
                }
            }
            String[] idParts = id.split(":");
            int meta = -1;
            if (idParts.length == 3) {
                meta = Integer.parseInt(idParts[2]);
                id = String.join((CharSequence)":", Arrays.copyOfRange(idParts, 0, 2));
            }
            PechTradesHelper.tryAddEntries(new PechTradesHelper.TradeEntry(pechType, tier, id, meta, tag), amount);
        }
        ci.cancel();
    }

    private static void otherEntitiesStuff() {
        int id = 0;
        ResourceLocation var10000 = new ResourceLocation("thaumcraft", "CultistPortalGreater");
        int var6 = id + 1;
        EntityRegistry.registerModEntity((ResourceLocation)var10000, EntityCultistPortalGreater.class, (String)"CultistPortalGreater", (int)id, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)false, (int)6842578, (int)32896);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "CultistPortalLesser"), EntityCultistPortalLesser.class, (String)"CultistPortalLesser", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)false, (int)9438728, (int)6316242);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "FluxRift"), EntityFluxRift.class, (String)"FluxRift", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "SpecialItem"), EntitySpecialItem.class, (String)"SpecialItem", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "FollowItem"), EntityFollowingItem.class, (String)"FollowItem", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "FallingTaint"), EntityFallingTaint.class, (String)"FallingTaint", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Alumentum"), EntityAlumentum.class, (String)"Alumentum", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "GolemDart"), EntityGolemDart.class, (String)"GolemDart", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "EldritchOrb"), EntityEldritchOrb.class, (String)"EldritchOrb", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "BottleTaint"), EntityBottleTaint.class, (String)"BottleTaint", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "GolemOrb"), EntityGolemOrb.class, (String)"GolemOrb", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Grapple"), EntityGrapple.class, (String)"Grapple", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "CausalityCollapser"), EntityCausalityCollapser.class, (String)"CausalityCollapser", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "FocusProjectile"), EntityFocusProjectile.class, (String)"FocusProjectile", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "FocusCloud"), EntityFocusCloud.class, (String)"FocusCloud", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Focusmine"), EntityFocusMine.class, (String)"Focusmine", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "TurretBasic"), EntityTurretCrossbow.class, (String)"TurretBasic", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "TurretAdvanced"), EntityTurretCrossbowAdvanced.class, (String)"TurretAdvanced", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "ArcaneBore"), EntityArcaneBore.class, (String)"ArcaneBore", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Golem"), EntityThaumcraftGolem.class, (String)"Golem", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "EldritchWarden"), EntityEldritchWarden.class, (String)"EldritchWarden", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)6842578, (int)0x808080);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "EldritchGolem"), EntityEldritchGolem.class, (String)"EldritchGolem", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)6842578, (int)0x888888);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "CultistLeader"), EntityCultistLeader.class, (String)"CultistLeader", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)6842578, (int)9438728);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "TaintacleGiant"), EntityTaintacleGiant.class, (String)"TaintacleGiant", (int)var6++, (Object)Thaumcraft.instance, (int)96, (int)3, (boolean)false, (int)6842578, (int)10618530);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "BrainyZombie"), EntityBrainyZombie.class, (String)"BrainyZombie", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)-16129, (int)-16744448);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "GiantBrainyZombie"), EntityGiantBrainyZombie.class, (String)"GiantBrainyZombie", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)-16129, (int)-16760832);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Wisp"), EntityWisp.class, (String)"Wisp", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)false, (int)-16129, (int)-1);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Firebat"), EntityFireBat.class, (String)"Firebat", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)false, (int)-16129, (int)-806354944);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Spellbat"), EntitySpellBat.class, (String)"Spellbat", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)false, (int)-16129, (int)-806354944);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Pech"), EntityPech.class, (String)"Pech", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)-16129, (int)-12582848);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "MindSpider"), EntityMindSpider.class, (String)"MindSpider", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)4996656, (int)0x444444);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "EldritchGuardian"), EntityEldritchGuardian.class, (String)"EldritchGuardian", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)0x808080, (int)0);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "CultistKnight"), EntityCultistKnight.class, (String)"CultistKnight", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)9438728, (int)128);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "CultistCleric"), EntityCultistCleric.class, (String)"CultistCleric", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)9438728, (int)0x800000);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "EldritchCrab"), EntityEldritchCrab.class, (String)"EldritchCrab", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)0x808080, (int)0x550000);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "InhabitedZombie"), EntityInhabitedZombie.class, (String)"InhabitedZombie", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)0x808080, (int)0x550000);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "ThaumSlime"), EntityThaumicSlime.class, (String)"ThaumSlime", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)10618530, (int)-32513);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "TaintCrawler"), EntityTaintCrawler.class, (String)"TaintCrawler", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)true, (int)10618530, (int)0x303030);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "Taintacle"), EntityTaintacle.class, (String)"Taintacle", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)false, (int)10618530, (int)0x443344);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "TaintacleTiny"), EntityTaintacleSmall.class, (String)"TaintacleTiny", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "TaintSwarm"), EntityTaintSwarm.class, (String)"TaintSwarm", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)3, (boolean)false, (int)10618530, (int)0xFF8080);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "TaintSeed"), EntityTaintSeed.class, (String)"TaintSeed", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)false, (int)10618530, (int)0x442255);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thaumcraft", "TaintSeedPrime"), EntityTaintSeedPrime.class, (String)"TaintSeedPrime", (int)var6++, (Object)Thaumcraft.instance, (int)64, (int)20, (boolean)false, (int)10618530, (int)0x553366);
    }
}

