/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer;

import com.nekokittygames.thaumictinkerer.api.MobAspects;
import com.nekokittygames.thaumictinkerer.api.ThaumicTinkererAPI;
import com.nekokittygames.thaumictinkerer.client.rendering.special.RenderTileWarpGate;
import com.nekokittygames.thaumictinkerer.common.blocks.AspectCropLootManager;
import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.commands.CommandDumpEnchants;
import com.nekokittygames.thaumictinkerer.common.commands.CommandRefreshMultiblocks;
import com.nekokittygames.thaumictinkerer.common.compat.Tconstruct.TConstructHandler;
import com.nekokittygames.thaumictinkerer.common.compat.botania.BotaniaCompat;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.dim.ModDimensions;
import com.nekokittygames.thaumictinkerer.common.dim.OreClusterGenerator;
import com.nekokittygames.thaumictinkerer.common.dim.OreFrequency;
import com.nekokittygames.thaumictinkerer.common.enchantments.TTEnchantments;
import com.nekokittygames.thaumictinkerer.common.foci.FocusCelestialTeleport;
import com.nekokittygames.thaumictinkerer.common.foci.FocusEffectDislocate;
import com.nekokittygames.thaumictinkerer.common.foci.FocusEffectEfreetFlame;
import com.nekokittygames.thaumictinkerer.common.foci.FocusEffectTelekenesis;
import com.nekokittygames.thaumictinkerer.common.foci.FocusEnderRift;
import com.nekokittygames.thaumictinkerer.common.loot.LootTableHandler;
import com.nekokittygames.thaumictinkerer.common.misc.ThaumicTInkererCreativeTab;
import com.nekokittygames.thaumictinkerer.common.misc.ThaumicTinkererAspectCreativeTab;
import com.nekokittygames.thaumictinkerer.common.packets.PacketHandler;
import com.nekokittygames.thaumictinkerer.common.proxy.ITTProxy;
import com.nekokittygames.thaumictinkerer.common.research.theorycraft.AidBlackQuartz;
import com.nekokittygames.thaumictinkerer.common.research.theorycraft.CardExperience;
import com.nekokittygames.thaumictinkerer.common.tileentity.Kami.TileWarpGate;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ScanEntity;
import thaumcraft.api.research.ScanningManager;
import thaumcraft.api.research.theorycraft.ITheorycraftAid;
import thaumcraft.api.research.theorycraft.TheorycraftManager;

@Mod(modid="thaumictinkerer", name="Thaumic Tinkerer Kedition", version="1.12.2-5.9.4-Unofficial", dependencies="required-after:thaumcraft", acceptedMinecraftVersions="[1.12.2]")
public class ThaumicTinkerer {
    public static Logger logger;
    private static CreativeTabs tab;
    private static CreativeTabs tabAspects;
    @SidedProxy(serverSide="com.nekokittygames.thaumictinkerer.common.proxy.CommonProxy", clientSide="com.nekokittygames.thaumictinkerer.client.proxy.ClientProxy")
    public static ITTProxy proxy;
    @Mod.Instance(value="thaumictinkerer")
    public static ThaumicTinkerer instance;

    public static CreativeTabs getTab() {
        return tab;
    }

    public static void setTab(CreativeTabs tab) {
        ThaumicTinkerer.tab = tab;
    }

    public static CreativeTabs getTabAspects() {
        return tabAspects;
    }

    public static void setTabAspects(CreativeTabs tabAspects) {
        ThaumicTinkerer.tabAspects = tabAspects;
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        tab = new ThaumicTInkererCreativeTab();
        tabAspects = new ThaumicTinkererAspectCreativeTab();
        logger = event.getModLog();
        proxy.preInit(event);
        if (Loader.isModLoaded((String)"tconstruct")) {
            TConstructHandler.preInit(event);
        }
        PacketHandler.registerMessages("thaumictinkerer");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreClusterGenerator(), (int)3);
        ModDimensions.init();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandRefreshMultiblocks());
        event.registerServerCommand((ICommand)new CommandDumpEnchants());
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.key.equalsIgnoreCase("addDislocateBlacklist") && message.isStringMessage()) {
                ThaumicTinkererAPI.getDislocationBlacklist().add(message.getStringValue());
            }
            if (!message.key.equalsIgnoreCase("addTabletBlacklist") || !message.isStringMessage()) continue;
            ThaumicTinkererAPI.getAnimationTabletBlacklist().add(message.getStringValue());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        ResearchCategories.registerCategory((String)"THAUMIC_TINKERER", (String)"UNLOCKARTIFICE", (AspectList)new AspectList(), (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/misc/advanced_auromancy.png"), (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/misc/sky1.png"), (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/misc/sky1.png"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/misc"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/baubles"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/machines"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/foci"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/kami"));
        TheorycraftManager.registerCard(CardExperience.class);
        ScanningManager.addScannableThing((IScanThing)new ScanEntity("!Ocelot", EntityOcelot.class, true));
        TheorycraftManager.registerAid((ITheorycraftAid)new AidBlackQuartz(ModBlocks.black_quartz_block));
        BotaniaCompat.addTheorycraft();
        proxy.registerRenderers();
        this.initFoci();
        MinecraftForge.EVENT_BUS.register(LootTableHandler.class);
        MobAspects.checkAspects();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        AspectCropLootManager.populateLootMap();
        OreFrequency.init();
    }

    private void initFoci() {
        if (TTConfig.DislocationFocusEnabled) {
            FocusEngine.registerElement(FocusEffectDislocate.class, (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/foci_icons/dislocation.png"), (int)15121988);
        }
        if (TTConfig.TelekenesisFocusEnabled) {
            logger.info("Initializing Telekenetic powers");
            FocusEngine.registerElement(FocusEffectTelekenesis.class, (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/foci_icons/telekenesis.png"), (int)0xCF00FF);
        }
        FocusEngine.registerElement(FocusEffectEfreetFlame.class, (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/foci_icons/efreetflame.png"), (int)25565230);
        FocusEngine.registerElement(FocusCelestialTeleport.class, (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/foci_icons/celestial_teleport.png"), (int)0x22F5FF);
        FocusEngine.registerElement(FocusEnderRift.class, (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/foci_icons/ender_rift.png"), (int)2833727);
    }

    @SubscribeEvent
    public static void onEnchantmentRegister(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])TTEnchantments.ENCHANTNENTS.toArray(new Enchantment[0]));
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventBusSubscriber
    public static class ObjectRegistryHandler {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void modelRegistryEvent(ModelRegistryEvent event) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileWarpGate.class, (TileEntitySpecialRenderer)new RenderTileWarpGate());
        }
    }
}

