/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.client.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.client.gui.button.GuiEnchantmentButton;
import com.nekokittygames.thaumictinkerer.client.gui.button.GuiEnchantmentLevelButton;
import com.nekokittygames.thaumictinkerer.client.gui.button.GuiEnchantmentStartButton;
import com.nekokittygames.thaumictinkerer.client.gui.button.GuiFramedEnchantmentButton;
import com.nekokittygames.thaumictinkerer.client.libs.LibClientResources;
import com.nekokittygames.thaumictinkerer.client.misc.ClientHelper;
import com.nekokittygames.thaumictinkerer.common.containers.EnchanterContainer;
import com.nekokittygames.thaumictinkerer.common.packets.PacketAddEnchant;
import com.nekokittygames.thaumictinkerer.common.packets.PacketHandler;
import com.nekokittygames.thaumictinkerer.common.packets.PacketIncrementEnchantLevel;
import com.nekokittygames.thaumictinkerer.common.packets.PacketRemoveEnchant;
import com.nekokittygames.thaumictinkerer.common.packets.PacketStartEnchant;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityEnchanter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class GuiEnchanter
extends GuiContainer {
    private static final int HEIGHT = 166;
    private static final int WIDTH = 176;
    private TileEntityEnchanter enchanter;
    private final GuiEnchantmentButton[] enchantButtons = new GuiEnchantmentButton[16];
    private GuiEnchantmentStartButton startButton;
    private final List<String> tooltip = new ArrayList<String>();
    private int visRequireWidth = 0;
    private int visRequireHeight = 0;
    private int cost = 0;
    private int x;
    private int y;
    private ItemStack lastTickItem;
    private ItemStack stack;
    private boolean workingLastTick = false;
    private boolean ready = false;

    public GuiEnchanter(TileEntityEnchanter tileEntity, EnchanterContainer container) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.enchanter = tileEntity;
        this.stack = this.enchanter.getInventory().getStackInSlot(0);
        this.cost = this.enchanter.getEnchantmentVisCost();
        this.lastTickItem = this.stack;
    }

    public TileEntityEnchanter getEnchanter() {
        return this.enchanter;
    }

    public void setEnchanter(TileEntityEnchanter enchanter) {
        this.enchanter = enchanter;
    }

    public List<String> getTooltip() {
        return this.tooltip;
    }

    public int getVisRequireWidth() {
        return this.visRequireWidth;
    }

    public void setVisRequireWidth(int visRequireWidth) {
        this.visRequireWidth = visRequireWidth;
    }

    public int getVisRequireHeight() {
        return this.visRequireHeight;
    }

    public void setVisRequireHeight(int visRequireHeight) {
        this.visRequireHeight = visRequireHeight;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.x = (this.field_146294_l - this.field_146999_f) / 2;
        this.y = (this.field_146295_m - this.field_147000_g) / 2;
        this.visRequireWidth = this.field_146289_q.func_78256_a("Required Vis Crystals") + 2;
        this.visRequireHeight = this.field_146289_q.field_78288_b + 2;
        this.buildButtonList();
    }

    private void buildButtonList() {
        int i;
        this.field_146292_n.clear();
        if (this.enchanter.isWorking()) {
            return;
        }
        for (i = 0; i < 16; ++i) {
            GuiEnchantmentButton button;
            int z = -11;
            if (i > 7) {
                z = 26;
            }
            if (this.enchantButtons[8] == null || !this.enchantButtons[8].field_146124_l) {
                z = 0;
            }
            this.enchantButtons[i] = button = new GuiEnchantmentButton(this, 1 + i, this.x + 38 + i % 8 * 16, this.y + 32 + z);
            this.field_146292_n.add(button);
        }
        this.asignEnchantButtons();
        i = 0;
        int xOffset = 0;
        for (Integer enchant : this.enchanter.getEnchantments()) {
            if (this.y + i * 26 + 30 + 15 + 24 > this.field_146295_m) {
                xOffset += 41;
                i = 0;
            }
            GuiFramedEnchantmentButton button = new GuiFramedEnchantmentButton(this, 17 + i * 3, this.x + this.field_146999_f + 4 + xOffset, this.y + i * 26 + 30 + 15);
            button.setEnchant(Enchantment.func_185262_c((int)enchant));
            this.field_146292_n.add(button);
            this.field_146292_n.add(new GuiEnchantmentLevelButton(17 + i * 3 + 1, this.x + this.field_146999_f + 24 + xOffset, this.y + i * 26 + 30 + 15 - 4, false));
            this.field_146292_n.add(new GuiEnchantmentLevelButton(17 + i * 3 + 2, this.x + this.field_146999_f + 31 + xOffset, this.y + i * 26 + 30 + 15 - 4, true));
            ++i;
        }
        this.startButton = new GuiEnchantmentStartButton(0, this.x + 8, this.y + 58);
        this.field_146292_n.add(this.startButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void asignEnchantButtons() {
        for (int i = 0; i < 16; ++i) {
            this.enchantButtons[i].setEnchant(null);
            this.enchantButtons[i].field_146124_l = false;
        }
        ItemStack currentStack = this.enchanter.getInventory().getStackInSlot(0);
        if (currentStack == ItemStack.field_190927_a || currentStack.func_77948_v()) {
            return;
        }
        int it = 0;
        for (int enchant : this.enchanter.getCachedEnchantments()) {
            this.enchantButtons[it].setEnchant(Enchantment.func_185262_c((int)enchant));
            this.enchantButtons[it].field_146124_l = true;
            if (++it < 16) continue;
            break;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.stack = this.enchanter.getInventory().getStackInSlot(0);
        if (!this.stack.equals(this.lastTickItem)) {
            if (this.stack == ItemStack.field_190927_a) {
                this.enchanter.clearEnchants();
            }
            this.buildButtonList();
            this.cost = this.enchanter.getEnchantmentVisCost();
        }
        this.lastTickItem = this.stack;
        if (this.enchanter.isWorking() != this.workingLastTick) {
            this.buildButtonList();
            this.cost = this.enchanter.getEnchantmentVisCost();
        }
        if (this.enchanter.isWorking()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.workingLastTick = this.enchanter.isWorking();
        if (this.startButton != null && this.enchanter.getEnchantments().size() > 0 && !this.enchanter.isWorking() && !this.stack.func_77948_v() && this.enchanter.playerHasIngredients(this.enchanter.getEnchantmentCost(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g) && this.enchanter.getAuraVisServer() > this.cost) {
            this.startButton.setEnabled(true);
            this.ready = true;
        } else if (this.startButton != null) {
            this.ready = false;
            this.startButton.setEnabled(false);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(LibClientResources.GUI_ENCHANTER);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.enchanter.getCachedEnchantments().size() > 0 && this.enchanter.getCachedEnchantments().size() < 9) {
            this.func_73729_b(this.x + 34, this.y + 28, 0, this.field_147000_g, 147, 24);
        } else if (this.enchanter.getCachedEnchantments().size() >= 8) {
            this.func_73729_b(this.x + 34, this.y + 17, 0, this.field_147000_g, 147, 24);
            this.func_73729_b(this.x + 34, this.y + 54, 0, this.field_147000_g, 147, 24);
        }
        if (mouseX >= this.x + 8 && mouseX < this.x + 8 + 15 && mouseY >= this.y + 58 && mouseY < this.y + 58 + 15) {
            if (this.ready) {
                this.getTooltip().add(ThaumicTinkerer.proxy.localize("ttmisc.enchanter.start", new Object[0]));
            } else {
                this.getTooltip().add(ThaumicTinkerer.proxy.localize("ttmisc.enchanter.notready", new Object[0]));
            }
        }
        this.field_146289_q.func_78276_b("Required Vis Crystals", this.x + 177, this.y + 7, 0x999999);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int j = 0;
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        for (ItemStack itemStack : this.enchanter.getEnchantmentCost()) {
            if (itemStack.func_190926_b()) continue;
            this.field_146296_j.func_180450_b(itemStack, this.x + 177 + j * 17, this.y + 7 + this.field_146289_q.field_78288_b);
            ItemCrystalEssence crystalEssence = (ItemCrystalEssence)itemStack.func_77973_b();
            Aspect aspect = crystalEssence.getAspects(itemStack).getAspectsSortedByAmount()[0];
            this.field_146296_j.func_180453_a(this.field_146289_q, itemStack, this.x + 177 + j * 17, this.y + 7 + this.field_146289_q.field_78288_b, "" + itemStack.func_190916_E());
            GlStateManager.func_179141_d();
            if (mouseX >= this.x + 177 + j * 17 && mouseX < this.x + 177 + j * 17 + 16 && mouseY >= this.y + 7 + this.field_146289_q.field_78288_b && mouseY < this.y + 7 + this.field_146289_q.field_78288_b + 16) {
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(ChatFormatting.AQUA + ThaumicTinkerer.proxy.localize(aspect.getName(), new Object[0]));
                this.getTooltip().addAll(tooltip);
            }
            ++j;
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected void func_146284_a(GuiButton button) {
        if (this.enchanter.isWorking()) {
            return;
        }
        if (button.field_146127_k == 0) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketStartEnchant(this.enchanter, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        } else if (button.field_146127_k <= 16) {
            GuiEnchantmentButton enchantButton = this.enchantButtons[button.field_146127_k - 1];
            if (enchantButton != null && enchantButton.getEnchant() != null) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAddEnchant(this.enchanter, Enchantment.func_185258_b((Enchantment)enchantButton.getEnchant())));
            }
        } else {
            int type = (button.field_146127_k - 17) % 3;
            int index = (button.field_146127_k - 17) / 3;
            if (index >= this.enchanter.getEnchantments().size() || index >= this.enchanter.getLevels().size()) {
                return;
            }
            if (type == 0) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRemoveEnchant(this.enchanter, (int)this.enchanter.getEnchantments().get(index)));
                this.enchanter.removeEnchant(index);
                this.enchanter.removeLevel(index);
                this.buildButtonList();
            } else {
                GuiEnchantmentLevelButton levelButton = (GuiEnchantmentLevelButton)button;
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketIncrementEnchantLevel(this.enchanter, (int)this.enchanter.getEnchantments().get(index), levelButton.plus));
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (!this.tooltip.isEmpty()) {
            ClientHelper.renderTooltip(mouseX - this.x, mouseY - this.y, this.tooltip);
        }
        this.tooltip.clear();
        String text = this.enchanter.getAuraVisServer() + " " + ThaumicTinkerer.proxy.localize("workbench.available", new Object[0]);
        this.field_146289_q.func_78276_b(text, 8, 75, this.enchanter.getAuraVisServer() < this.cost ? 0xEE6E6E : 0x6E6EEE);
    }
}

