/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.client.rendering.tileentities;

import com.nekokittygames.thaumictinkerer.client.libs.LibClientResources;
import com.nekokittygames.thaumictinkerer.client.misc.ClientHelper;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityAnimationTablet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityAnimationTabletRenderer
extends TileEntitySpecialRenderer<TileEntityAnimationTablet> {
    private static final float[][] TRANSLATIONS = new float[][]{{0.0f, 0.0f, -1.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, -1.0f}};

    public void render(TileEntityAnimationTablet te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        int index = 2;
        if (te.getFacing() != null) {
            index = te.getFacing().func_176745_a();
        }
        if (index < 2) {
            index = 2;
        }
        this.renderOverlay(te, LibClientResources.MISC_AT_CENTER, -1, false, false, 0.65, 0.13f, 0.0f);
        if (!te.isRightClick()) {
            this.renderOverlay(te, LibClientResources.MISC_AT_LEFT, 1, false, true, 1.0, 0.131f, 0.0f);
        } else {
            this.renderOverlay(te, LibClientResources.MISC_AT_RIGHT, 1, false, true, 1.0, 0.131f, 0.0f);
        }
        this.renderOverlay(te, LibClientResources.MISC_AT_INDENT, 0, false, false, 0.5, 0.132f, ClientHelper.toDegrees(te.getFacing()) + 90.0f);
        GlStateManager.func_179114_b((float)ClientHelper.toDegrees(te.getFacing()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.1, (double)(0.2 + Math.cos((double)System.currentTimeMillis() / 600.0) / 18.0), (double)0.5);
        float[] translations = TRANSLATIONS[index - 2];
        GlStateManager.func_179109_b((float)translations[0], (float)translations[1], (float)translations[2]);
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
        GlStateManager.func_179114_b((float)te.getProgress(), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.cos((float)System.currentTimeMillis() / 400.0f) * 5.0f), (float)1.0f, (float)0.0f, (float)1.0f);
        ItemStack stack = te.getInventory().getStackInSlot(0);
        if (stack != ItemStack.field_190927_a) {
            EntityItem customitem = new EntityItem(te.func_145831_w(), 0.0, 0.0, 0.0, stack.func_77946_l());
            customitem.func_92059_d().func_190920_e(1);
            customitem.field_70290_d = 0.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.5f, (float)0.55f, (float)0.0f);
            if (stack.func_77973_b() instanceof ItemBlock) {
                GlStateManager.func_179139_a((double)2.5, (double)2.5, (double)2.5);
            } else {
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
            }
            if (!Minecraft.func_71410_x().func_175599_af().func_175050_a(customitem.func_92059_d())) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            Minecraft.func_71410_x().func_175599_af().func_181564_a(customitem.func_92059_d(), ItemCameraTransforms.TransformType.GROUND);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private void renderOverlay(TileEntityAnimationTablet tablet, ResourceLocation texture, int rotationMod, boolean useLighting, boolean useBlend, double size, float height, float forceDeg) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(texture);
        GlStateManager.func_179094_E();
        if (!useLighting) {
            GlStateManager.func_179140_f();
        }
        if (useBlend) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
        }
        GlStateManager.func_179109_b((float)0.5f, (float)height, (float)0.5f);
        float deg = rotationMod == 0 ? forceDeg : (float)(tablet.getTicksExisted() * rotationMod) % 360.0f;
        GlStateManager.func_179114_b((float)deg, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tess = Tessellator.func_178181_a();
        double size1 = size / 2.0;
        double size2 = -size1;
        BufferBuilder bufferBuilder = tess.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(size2, 0.0, size1).func_187315_a(0.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(size1, 0.0, size1).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(size1, 0.0, size2).func_187315_a(1.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(size2, 0.0, size2).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        if (!useLighting) {
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179121_F();
    }
}

