/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.blocks;

import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.items.ItemInfusedSeeds;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class AspectCropLootManager {
    private static HashMap<Aspect, HashMap<ItemStack, Integer>> lootMap = new HashMap();

    public static ItemStack getLootForAspect(Aspect aspect) {
        HashMap<ItemStack, Integer> aspectHashmap = lootMap.get(aspect);
        if (aspectHashmap == null) {
            return ItemStack.field_190927_a;
        }
        int sum = 0;
        for (Integer i : aspectHashmap.values()) {
            sum += i.intValue();
        }
        if (sum > 0) {
            Random rand = new Random();
            int randInt = rand.nextInt(sum);
            for (Map.Entry<ItemStack, Integer> pair : aspectHashmap.entrySet()) {
                if (randInt <= 0) {
                    return pair.getKey().func_77946_l();
                }
                randInt -= pair.getValue().intValue();
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void addAspectLoot(Aspect aspect, ItemStack stack) {
        AspectCropLootManager.addAspectLoot(aspect, stack, 1);
    }

    public static void addAspectLoot(Aspect aspect, String target) {
        for (String ore : OreDictionary.getOreNames()) {
            if (!ore.contains(WordUtils.capitalizeFully((String)target)) && !ore.contains(target)) continue;
            NonNullList ores = OreDictionary.getOres((String)ore);
            for (ItemStack stack : ores) {
                AspectCropLootManager.addAspectLoot(aspect, stack);
            }
        }
    }

    public static void addAspectLoot(Aspect aspect, String target, int count) {
        for (String ore : OreDictionary.getOreNames()) {
            if (!ore.contains(WordUtils.capitalizeFully((String)target)) && !ore.contains(target)) continue;
            NonNullList ores = OreDictionary.getOres((String)ore);
            for (ItemStack stack : ores) {
                ItemStack newStack = stack.func_77946_l();
                newStack.func_190920_e(count);
                AspectCropLootManager.addAspectLoot(aspect, newStack);
            }
        }
    }

    public static void addAspectLoot(Aspect aspect, ItemStack stack, int power) {
        lootMap.get(aspect).put(stack, power);
    }

    public static void populateLootMap() {
        Aspect.aspects.values().forEach(a -> lootMap.put((Aspect)a, new HashMap()));
        AspectCropLootManager.addPrimalAspectSeeds();
        AspectCropLootManager.addAspectLoot(Aspect.ORDER, new ItemStack(Blocks.field_150359_w, 4));
        AspectCropLootManager.addAspectLoot(Aspect.ENTROPY, new ItemStack((Block)Blocks.field_150354_m, 4));
        AspectCropLootManager.addElditchAspectLoot();
        AspectCropLootManager.addTreeAspectLoot();
        AspectCropLootManager.addAuraAspectLoot();
        AspectCropLootManager.addBeastAspectLoot();
        AspectCropLootManager.addMindAspectLoot();
        AspectCropLootManager.addFleshAndUndeadAspectLoot();
        AspectCropLootManager.addCraftAspectLoot();
        AspectCropLootManager.addElementalAspectLoot();
        AspectCropLootManager.addNatureAspectLoot();
        AspectCropLootManager.addHumanAspectLoot();
        AspectCropLootManager.addToolsAndArmorAspectLoot();
        AspectCropLootManager.addMaterialAspectLoot();
        AspectCropLootManager.addMechanicalAspectLoot();
        AspectCropLootManager.addEnergyAspectLoot();
        AspectCropLootManager.addMagicAspectLoot();
        AspectCropLootManager.addSensoryAspectLoot();
        AspectCropLootManager.addOtherAspectLoot();
    }

    private static void addPrimalAspectSeeds() {
        Aspect[] primalAspects;
        for (Aspect aspect : primalAspects = new Aspect[]{Aspect.AIR, Aspect.FIRE, Aspect.EARTH, Aspect.WATER}) {
            ItemStack seedStack = new ItemStack((Item)ModItems.infused_seeds);
            ItemInfusedSeeds.setAspect(seedStack, aspect);
            AspectCropLootManager.addAspectLoot(aspect, seedStack);
        }
        AspectCropLootManager.addAspectLoot(Aspect.AIR, new ItemStack(ModItems.fruit_aer));
        AspectCropLootManager.addAspectLoot(Aspect.FIRE, new ItemStack(ModItems.fruit_ignis));
        AspectCropLootManager.addAspectLoot(Aspect.EARTH, new ItemStack(ModItems.fruit_terra));
        AspectCropLootManager.addAspectLoot(Aspect.WATER, new ItemStack(ModItems.fruit_aqua));
    }

    private static void addElditchAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.ELDRITCH, new ItemStack(Items.field_151079_bi, 1), 10);
        AspectCropLootManager.addAspectLoot(Aspect.ELDRITCH, new ItemStack(Items.field_151061_bv, 1), 5);
        AspectCropLootManager.addAspectLoot(Aspect.ELDRITCH, "bucketEnder");
    }

    private static void addTreeAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.PLANT, "wood");
        AspectCropLootManager.addAspectLoot(Aspect.PLANT, new ItemStack(Blocks.field_150364_r));
    }

    private static void addAuraAspectLoot() {
        for (Aspect tag : Aspect.aspects.values()) {
            ItemStack wisp = new ItemStack(ItemsTC.crystalEssence);
            ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(wisp, new AspectList().add(tag, 2));
            AspectCropLootManager.addAspectLoot(Aspect.AURA, wisp);
        }
    }

    private static void addBeastAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.BEAST, new ItemStack(Items.field_151110_aK, 1));
    }

    private static void addMindAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.MIND, new ItemStack(Items.field_151121_aF, 4), 15);
        AspectCropLootManager.addAspectLoot(Aspect.MIND, new ItemStack(Items.field_151122_aG, 2), 10);
        AspectCropLootManager.addAspectLoot(Aspect.MIND, new ItemStack(Blocks.field_150342_X, 1), 5);
    }

    private static void addFleshAndUndeadAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.DEATH, new ItemStack(ItemsTC.tallow, 1), 4);
        AspectCropLootManager.addAspectLoot(Aspect.UNDEAD, new ItemStack(Items.field_151078_bh, 2));
    }

    private static void addCraftAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.CRAFT, new ItemStack(Item.func_150898_a((Block)ModBlocks.black_quartz_block), 2));
        AspectCropLootManager.addAspectLoot(Aspect.CRAFT, new ItemStack(BlocksTC.arcaneWorkbench, 1));
    }

    private static void addElementalAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.COLD, new ItemStack(Items.field_151126_ay, 1));
        AspectCropLootManager.addAspectLoot(Aspect.COLD, "rodBlizz");
    }

    private static void addNatureAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.PLANT, "sapling");
        for (int i = 0; i < 6; ++i) {
            AspectCropLootManager.addAspectLoot(Aspect.PLANT, new ItemStack(Blocks.field_150345_g, 1, i));
        }
    }

    private static void addHumanAspectLoot() {
        for (int i = 0; i < 12; ++i) {
            AspectCropLootManager.addAspectLoot(Aspect.MAN, new ItemStack(ItemsTC.seals, 1, i));
        }
    }

    private static void addToolsAndArmorAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.PROTECT, new ItemStack((Item)Items.field_151175_af));
        AspectCropLootManager.addAspectLoot(Aspect.PROTECT, new ItemStack((Item)Items.field_151173_ae));
        AspectCropLootManager.addAspectLoot(Aspect.PROTECT, new ItemStack((Item)Items.field_151163_ad));
        AspectCropLootManager.addAspectLoot(Aspect.PROTECT, new ItemStack((Item)Items.field_151161_ac));
        AspectCropLootManager.addAspectLoot(Aspect.TOOL, new ItemStack(ItemsTC.thaumiumPick));
        AspectCropLootManager.addAspectLoot(Aspect.TOOL, new ItemStack(ItemsTC.thaumiumAxe));
        AspectCropLootManager.addAspectLoot(Aspect.TOOL, new ItemStack(ItemsTC.thaumiumHoe));
        AspectCropLootManager.addAspectLoot(Aspect.TOOL, new ItemStack(ItemsTC.thaumiumSword));
        AspectCropLootManager.addAspectLoot(Aspect.TOOL, new ItemStack(ItemsTC.thaumiumShovel));
    }

    private static void addMaterialAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.METAL, new ItemStack(Items.field_151042_j, 1), 100);
        AspectCropLootManager.addAspectLoot(Aspect.METAL, new ItemStack(Items.field_151043_k, 1));
        AspectCropLootManager.addAspectLoot(Aspect.CRYSTAL, new ItemStack(Items.field_151045_i));
    }

    private static void addMechanicalAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.MECHANISM, new ItemStack((Block)Blocks.field_150331_J, 1));
        AspectCropLootManager.addAspectLoot(Aspect.MECHANISM, "gear");
        AspectCropLootManager.addAspectLoot(Aspect.MOTION, new ItemStack(Blocks.field_150448_aq), 1);
        AspectCropLootManager.addAspectLoot(Aspect.MOTION, new ItemStack(Blocks.field_150408_cc));
    }

    private static void addEnergyAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.ENERGY, new ItemStack(Items.field_151137_ax, 2));
    }

    private static void addMagicAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.MAGIC, "shard");
    }

    private static void addSensoryAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.LIGHT, new ItemStack(Items.field_151114_aO, 1), 5);
        AspectCropLootManager.addAspectLoot(Aspect.LIGHT, new ItemStack(ItemsTC.alumentum, 4));
        AspectCropLootManager.addAspectLoot(Aspect.LIGHT, new ItemStack((Item)ModItems.energetic_nitor));
    }

    private static void addOtherAspectLoot() {
        AspectCropLootManager.addAspectLoot(Aspect.DARKNESS, new ItemStack(Blocks.field_150343_Z, 1));
        AspectCropLootManager.addAspectLoot(Aspect.VOID, new ItemStack(Items.field_151133_ar));
        AspectCropLootManager.addAspectLoot(Aspect.VOID, "bucket");
        AspectCropLootManager.addAspectLoot(Aspect.LIFE, new ItemStack(Items.field_151110_aK, 1));
        AspectCropLootManager.addAspectLoot(Aspect.TRAP, new ItemStack(Blocks.field_150321_G, 1));
        AspectCropLootManager.addAspectLoot(Aspect.FLUX, new ItemStack(ItemsTC.voidSeed, 1));
    }
}

