/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.blocks;

import com.nekokittygames.thaumictinkerer.common.blocks.TTTileEntity;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityFunnel;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public class BlockFunnel
extends TTTileEntity<TileEntityFunnel> {
    public static final PropertyBool JAR = PropertyBool.func_177716_a((String)"jar");

    public BlockFunnel() {
        super("funnel", Material.field_151576_e, true);
        this.func_149711_c(3.0f);
        this.func_149752_b(8.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)JAR, (Comparable)Boolean.valueOf(false)));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{JAR});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityFunnel) {
            TileEntityFunnel funnel = (TileEntityFunnel)te;
            if (funnel.getInventory().getStackInSlot(0) == ItemStack.field_190927_a) {
                return state.func_177226_a((IProperty)JAR, (Comparable)Boolean.valueOf(false));
            }
            return state.func_177226_a((IProperty)JAR, (Comparable)Boolean.valueOf(true));
        }
        return state.func_177226_a((IProperty)JAR, (Comparable)Boolean.valueOf(false));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)JAR, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150438_bZ;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFunnel();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityFunnel)) {
            return false;
        }
        TileEntityFunnel funnel = (TileEntityFunnel)te;
        ItemStack stack = funnel.getInventory().getStackInSlot(0);
        ItemStack playerStack = playerIn.func_184586_b(hand);
        if (stack == ItemStack.field_190927_a) {
            if (worldIn.field_72995_K) {
                return true;
            }
            if (playerIn.func_184614_ca().func_190926_b()) {
                funnel.func_70296_d();
                return true;
            }
            if (funnel.isItemValidForSlot(0, playerStack)) {
                funnel.getInventory().insertItem(0, playerStack.func_77946_l(), false);
                playerStack.func_190920_e(playerStack.func_190916_E() - 1);
                if (playerStack.func_190926_b()) {
                    playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
                funnel.func_70296_d();
                return true;
            }
        } else {
            if (!playerStack.func_190926_b()) {
                Item playerItem = playerStack.func_77973_b();
                if (playerStack.func_190916_E() == 1 && funnel.isItemValidForSlot(0, playerStack)) {
                    ItemStack jar = stack.func_77946_l();
                    funnel.getInventory().setStackInSlot(0, playerStack);
                    this.clearTagsFromEmptyJar(jar);
                    playerIn.func_184611_a(hand, jar);
                    funnel.func_70296_d();
                    return true;
                }
                return false;
            }
            if (!playerIn.func_70093_af()) {
                if (worldIn.field_72995_K) {
                    return true;
                }
                ItemStack jar = stack.func_77946_l();
                this.clearTagsFromEmptyJar(jar);
                if (!playerIn.field_71071_by.func_70441_a(jar)) {
                    playerIn.func_71019_a(jar, false);
                }
                funnel.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
            } else if (worldIn.field_72995_K) {
                return true;
            }
            funnel.func_70296_d();
            return true;
        }
        return false;
    }

    private ItemStack clearTagsFromEmptyJar(ItemStack jar) {
        IEssentiaContainerItem item = (IEssentiaContainerItem)jar.func_77973_b();
        if (item.getAspects(jar) == null || item.getAspects(jar).getAspects().length == 0) {
            Aspect aspectFromTag = BlockFunnel.getAspectFromTag(jar);
            NBTTagCompound itemTags = null;
            if (aspectFromTag != null) {
                itemTags = new NBTTagCompound();
                itemTags.func_74778_a("AspectFilter", aspectFromTag.getTag());
            }
            jar.func_77982_d(itemTags);
        }
        return jar;
    }

    public static Aspect getAspectFromTag(ItemStack jar) {
        NBTTagCompound itemTags = jar.func_77978_p();
        if (itemTags != null) {
            String aspectName = itemTags.func_74779_i("AspectFilter");
            return Aspect.getAspect((String)aspectName);
        }
        return null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityFunnel funnel = (TileEntityFunnel)worldIn.func_175625_s(pos);
        ItemStack inv = funnel.getInventory().getStackInSlot(0);
        if (inv != ItemStack.field_190927_a) {
            EntityItem item = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), inv);
            worldIn.func_72838_d((Entity)item);
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

