/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.blocks;

import com.nekokittygames.thaumictinkerer.common.blocks.AspectCropLootManager;
import com.nekokittygames.thaumictinkerer.common.items.ItemInfusedSeeds;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileInfusedFarmland;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileInfusedGrain;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class BlockInfusedGrain
extends BlockCrops {
    private TileInfusedGrain tileEntity;
    public static final int BREEDING_CHANCE = 10;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);

    public BlockInfusedGrain() {
        this.setRegistryName("thaumictinkerer", "infused_grain_block");
        this.func_149663_c("infused_grain_block");
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public static int getNumberFromAspectForTexture(Aspect aspect) {
        if (aspect == Aspect.AIR) {
            return 0;
        }
        if (aspect == Aspect.FIRE) {
            return 1;
        }
        if (aspect == Aspect.WATER) {
            return 2;
        }
        if (aspect == Aspect.EARTH) {
            return 3;
        }
        if (aspect == Aspect.ORDER) {
            return 4;
        }
        if (aspect == Aspect.ENTROPY) {
            return 5;
        }
        return 6;
    }

    @Nullable
    public static Aspect getAspect(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileInfusedGrain ? ((TileInfusedGrain)te).aspect : null;
    }

    public static void setAspect(IBlockAccess world, BlockPos pos, Aspect aspect) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileInfusedGrain) {
            ((TileInfusedGrain)te).aspect = aspect;
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.func_176475_e(world, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world1, BlockPos pos, IBlockState state, int fortune) {
        World world = (World)world1;
        if (world == null) {
            return;
        }
        Random rand = new Random();
        int metadata = this.func_185527_x(state);
        int count = 1;
        for (int i = 0; i < count; ++i) {
            TileInfusedGrain tileGrain = this.getTileEntitySafe(world, pos);
            ItemStack seedStack = new ItemStack((Item)ModItems.infused_seeds);
            ItemInfusedSeeds.setAspect(seedStack, this.getAspectDropped(world, pos, metadata));
            if (tileGrain != null) {
                ItemInfusedSeeds.setAspectTendencies(seedStack, tileGrain.primalTendencies);
            }
            while ((double)rand.nextInt(10000) < Math.pow(this.getPrimalTendencyCount(world, pos, Aspect.ENTROPY), 2.0)) {
                seedStack.func_190920_e(seedStack.func_190916_E() + 1);
            }
            drops.add((Object)seedStack);
            this.fertilizeSoil(world, pos, metadata);
        }
        if (this.func_176201_c(state) >= 7) {
            do {
                Aspect aspect;
                ItemStack retItem;
                if ((retItem = AspectCropLootManager.getLootForAspect(aspect = this.getAspectSafe(world, pos))) == null) continue;
                drops.add((Object)retItem);
            } while (world.field_73012_v.nextInt(75) < this.getPrimalTendencyCount(world, pos, Aspect.ORDER));
        }
        this.tileEntity = null;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public int getPrimalTendencyCount(World world, BlockPos pos, Aspect aspect) {
        TileInfusedGrain tileGrain = this.getTileEntitySafe(world, pos);
        return tileGrain != null ? tileGrain.primalTendencies.getAmount(aspect) : 0;
    }

    private int getPrimalTendencyCount(TileInfusedGrain grain, Aspect aspect) {
        return grain.primalTendencies != null ? grain.primalTendencies.getAmount(aspect) : 0;
    }

    private void fertilizeSoil(World world, BlockPos pos, int metadata) {
        if (metadata >= 7) {
            TileEntity te = world.func_175625_s(pos.func_177977_b());
            if (!(te instanceof TileInfusedFarmland)) {
                return;
            }
            TileInfusedFarmland farmland = (TileInfusedFarmland)te;
            TileInfusedGrain grain = (TileInfusedGrain)world.func_175625_s(pos);
            if (grain == null) {
                return;
            }
            do {
                Aspect currentAspect;
                if ((currentAspect = BlockInfusedGrain.getAspect((IBlockAccess)world, pos)) == null) continue;
                farmland.aspectList.add(currentAspect, 1);
                farmland.reduceSaturatedAspects();
                world.func_184138_a(pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), world.func_180495_p(pos.func_177977_b()), 3);
            } while (world.field_73012_v.nextInt(55) < this.getPrimalTendencyCount(grain, Aspect.EARTH));
        }
    }

    public Aspect getAspectDropped(World world, BlockPos pos, int metadata) {
        TileEntity te;
        Aspect currentAspect = BlockInfusedGrain.getAspect((IBlockAccess)world, pos);
        if (metadata >= 7 && currentAspect != null && (te = world.func_175625_s(pos.func_177977_b())) instanceof TileInfusedFarmland) {
            TileInfusedFarmland farmland = (TileInfusedFarmland)te;
            AspectList farmlandAspectList = farmland.aspectList;
            for (Aspect aspect : farmlandAspectList.getAspects()) {
                Aspect result;
                Random rand = new Random();
                TileInfusedGrain grain = (TileInfusedGrain)world.func_175625_s(pos);
                if (rand.nextInt(10) >= (this.getPrimalTendencyCount(grain, Aspect.FIRE) + 1) * farmlandAspectList.getAmount(aspect) * farmlandAspectList.getAmount(aspect) || (result = AspectHelper.getCombinationResult((Aspect)aspect, (Aspect)currentAspect)) == null) continue;
                return result;
            }
        }
        return currentAspect;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileInfusedGrain();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    private TileInfusedGrain getTileEntitySafe(World world, BlockPos pos) {
        if (this.tileEntity != null) {
            return this.tileEntity;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileInfusedGrain) {
            return (TileInfusedGrain)tile;
        }
        return null;
    }

    private Aspect getAspectSafe(World world, BlockPos pos) {
        if (this.tileEntity != null) {
            return this.tileEntity.aspect;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileInfusedGrain) {
            return ((TileInfusedGrain)tile).aspect;
        }
        return null;
    }
}

