/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.dim;

import com.nekokittygames.thaumictinkerer.common.dim.OreClusterGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import org.apache.commons.lang3.StringUtils;

public class ChunkGeneratorMining
implements IChunkGenerator {
    private static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    private final List<Tuple<? extends MapGenBase, BooleanSupplier>> mapGen = new ArrayList<Tuple<? extends MapGenBase, BooleanSupplier>>();
    private final World world;
    private final long seed;
    private Random rng;
    private OreClusterGenerator generator;

    public ChunkGeneratorMining(World world, long seed) {
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE), () -> false);
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE), () -> false);
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT), () -> false);
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD), () -> false);
        this.addMapGen(TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE), () -> false);
        this.world = world;
        this.seed = seed;
        this.generator = new OreClusterGenerator();
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        int height = 256;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < height; ++y) {
                    primer.func_177855_a(x, y, z, BEDROCK);
                }
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rng = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L + this.seed);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(chunkX, chunkZ, primer);
        Biome[] biomes = this.world.func_72959_q().func_76937_a(null, chunkX << 4, chunkZ << 4, 16, 16);
        for (int xD = 0; xD < 16; ++xD) {
            int x = chunkX << 4 | xD;
            for (int zD = 0; zD < 16; ++zD) {
                int z = chunkZ << 4 | zD;
                biomes[xD << 4 | zD].func_180622_a(this.world, this.rng, primer, x, z, 0.0);
            }
        }
        for (Tuple<? extends MapGenBase, BooleanSupplier> gen : this.mapGen) {
            if (!((BooleanSupplier)gen.func_76340_b()).getAsBoolean()) continue;
            ((MapGenBase)gen.func_76341_a()).func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int par2, int par3) {
        if (this.rng != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(this.rng.nextLong()))) {
            this.rng.setSeed(this.world.func_72905_C());
            long i1 = this.rng.nextLong() / 2L * 2L + 1L;
            long j1 = this.rng.nextLong() / 2L * 2L + 1L;
            this.rng.setSeed((long)par2 * i1 + (long)par3 * j1 ^ this.world.func_72905_C());
            if (this.generator != null) {
                this.generator.generate(this.rng, par2, par3, this.world, this, this.world.func_72863_F());
            }
        }
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        return null;
    }

    @Nullable
    public BlockPos func_180513_a(World world, String s, BlockPos blockPos, boolean b) {
        return null;
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        for (Tuple<? extends MapGenBase, BooleanSupplier> t : this.mapGen) {
            if (!(t.func_76341_a() instanceof MapGenStructure)) continue;
            ((MapGenBase)t.func_76341_a()).func_186125_a(this.world, chunkX, chunkZ, null);
        }
    }

    public boolean func_193414_a(World world, String s, BlockPos blockPos) {
        return false;
    }

    private void addMapGen(MapGenBase gen, BooleanSupplier active) {
        Tuple t = new Tuple((Object)gen, (Object)active);
        this.mapGen.add((Tuple<? extends MapGenBase, BooleanSupplier>)t);
    }
}

