/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.foci;

import com.nekokittygames.thaumictinkerer.common.misc.MiscHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpact;

public class FocusEffectTelekenesis
extends FocusEffect {
    public boolean execute(RayTraceResult paramRayTraceResult, @Nullable Trajectory paramTrajectory, float paramFloat, int paramInt) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXFocusPartImpact(paramRayTraceResult.field_72307_f.field_72450_a, paramRayTraceResult.field_72307_f.field_72448_b, paramRayTraceResult.field_72307_f.field_72449_c, new String[]{this.getKey()}), new NetworkRegistry.TargetPoint(this.getPackage().world.field_73011_w.getDimension(), paramRayTraceResult.field_72307_f.field_72450_a, paramRayTraceResult.field_72307_f.field_72448_b, paramRayTraceResult.field_72307_f.field_72449_c, 64.0));
        this.getPackage().world.func_184148_a(null, paramRayTraceResult.field_72307_f.field_72450_a, paramRayTraceResult.field_72307_f.field_72448_b, paramRayTraceResult.field_72307_f.field_72449_c, SoundsTC.scan, SoundCategory.PLAYERS, 0.7f, 1.4f + (float)(this.getPackage().getCaster().field_70170_p.field_73012_v.nextGaussian() * (double)0.05f));
        if (paramRayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        if (paramTrajectory == null) {
            return false;
        }
        Vector3 target = new Vector3(paramTrajectory.source);
        int range = 6 + this.getSettingValue("power");
        double distance = range - 1;
        if (this.getPackage().getCaster().func_70093_af()) {
            target.add(new Vector3(this.getPackage().getCaster().func_70040_Z()).multiply(distance));
        }
        target.y += 0.5;
        List entities = this.getPackage().world.func_72872_a(EntityItem.class, new AxisAlignedBB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range));
        if (!entities.isEmpty()) {
            for (EntityItem item : entities) {
                MiscHelper.setEntityMotionFromVector((Entity)item, target, 0.3333f);
            }
        }
        return false;
    }

    public NodeSetting[] createSettings() {
        return new NodeSetting[]{new NodeSetting("power", "focus.common.power", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(1, 5))};
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundsTC.hhoff, SoundCategory.PLAYERS, 0.8f, 1.15f + (float)(caster.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        FXGeneric pp = new FXGeneric(world, posX, posY, posZ, velX, velY, velZ);
        pp.func_187114_a(9);
        pp.func_70538_b(0.25f + world.field_73012_v.nextFloat() * 0.25f, 0.25f + world.field_73012_v.nextFloat() * 0.25f, 0.25f + world.field_73012_v.nextFloat() * 0.25f);
        pp.setAlphaF(new float[]{0.0f, 0.6f, 0.6f, 0.0f});
        pp.setGridSize(64);
        pp.setParticles(448, 9, 1);
        pp.setScale(new float[]{0.5f, 0.25f});
        pp.setGravity((float)(world.field_73012_v.nextGaussian() * (double)0.009f));
        pp.setRandomMovementScale(0.0025f, 0.0025f, 0.0025f);
        ParticleEngine.addEffect((World)world, (Particle)pp);
    }

    public int getComplexity() {
        return 3 * this.getSettingValue("power");
    }

    public Aspect getAspect() {
        return Aspect.MAGIC;
    }

    public String getKey() {
        return "thaumictinkerer.TELEKENESIS";
    }

    public String getResearch() {
        return "TT_TELEKENESIS";
    }
}

