/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.potions.PotionBlurredVision;
import thaumcraft.common.lib.potions.PotionDeathGaze;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumcraft.common.lib.potions.PotionSunScorned;
import thaumcraft.common.lib.potions.PotionUnnaturalHunger;
import thaumcraft.common.lib.potions.PotionWarpWard;

public class ItemCleansingTalisman
extends TTItem
implements IBauble {
    private static final String TAG_ENABLED = "enabled";

    public ItemCleansingTalisman() {
        super("cleaning_talisman");
        this.func_77625_d(1);
        this.func_77656_e(TTConfig.talismanUses);
        this.func_185043_a(new ResourceLocation("active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (ItemCleansingTalisman.isEnabled(stack)) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_ENABLED, false);
    }

    public static void flipEnabled(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_ENABLED, !ItemCleansingTalisman.isEnabled(stack));
    }

    public ActionResult<ItemStack> func_77659_a(World par2World, EntityPlayer par3EntityPlayer, @Nonnull EnumHand hand) {
        ItemStack stack = par3EntityPlayer.func_184586_b(hand);
        if (par3EntityPlayer.func_70093_af()) {
            ItemCleansingTalisman.flipEnabled(stack);
            par2World.func_184133_a(null, par3EntityPlayer.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.3f, 0.1f);
        }
        return super.func_77659_a(par2World, par3EntityPlayer, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        if (ItemCleansingTalisman.isEnabled(par1ItemStack)) {
            stacks.add(I18n.func_135052_a((String)"ttmisc.active", (Object[])new Object[0]));
        } else {
            stacks.add(I18n.func_135052_a((String)"ttmisc.inactive", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.UNCOMMON;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.CHARM;
    }

    public void onWornTick(ItemStack par1ItemStack, EntityLivingBase player) {
        World par2World = player.field_70170_p;
        if (ItemCleansingTalisman.isEnabled(par1ItemStack) && !par2World.field_72995_K && par1ItemStack.func_77973_b() == this && player.field_70173_aa % 20 == 0 && player instanceof EntityPlayer) {
            boolean removed = false;
            int damage = 1;
            Collection potions = player.func_70651_bq();
            if (player.func_70027_ad()) {
                player.func_70066_B();
                removed = true;
            } else {
                for (PotionEffect potion : potions) {
                    Potion id = potion.func_188419_a();
                    boolean badEffect = (Boolean)ReflectionHelper.getPrivateValue(Potion.class, (Object)id, (String)"isBadEffect", (String)"field_76418_K");
                    if (id instanceof PotionWarpWard) {
                        badEffect = false;
                    }
                    if (!badEffect) continue;
                    player.func_184589_d(id);
                    removed = true;
                    Object[] warpPotionIDs = new Potion[]{PotionBlurredVision.instance, PotionDeathGaze.instance, PotionInfectiousVisExhaust.instance, PotionSunScorned.instance, PotionUnnaturalHunger.instance};
                    if (!ArrayUtils.contains((Object[])warpPotionIDs, (Object)potion.func_188419_a())) break;
                    damage = 10;
                    break;
                }
            }
            if (removed) {
                par1ItemStack.func_77972_a(damage, player);
                if (par1ItemStack.func_77952_i() <= 0) {
                    BaublesApi.getBaubles((EntityPlayer)((EntityPlayer)player)).func_70299_a(BaubleType.CHARM.getValidSlots()[0], ItemStack.field_190927_a);
                }
                par2World.func_184133_a(null, player.func_180425_c(), SoundsTC.wand, SoundCategory.PLAYERS, 0.3f, 0.1f);
            }
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

