/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items;

import com.nekokittygames.thaumictinkerer.common.blocks.BlockInfusedGrain;
import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileInfusedGrain;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public class ItemInfusedSeeds
extends ItemSeeds
implements IEssentiaContainerItem {
    private static final String NBT_MAIN_ASPECT = "mainAspect";
    private static final String NBT_ASPECT_TENDENCIES = "aspectTendencies";

    public ItemInfusedSeeds() {
        super((Block)ModBlocks.infused_grain, Blocks.field_150458_ak);
        this.setRegistryName(new ResourceLocation("thaumictinkerer", "infused_seeds"));
        this.func_77655_b("infused_seeds");
        this.func_185043_a(new ResourceLocation("meta"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (ItemInfusedSeeds.getAspect(stack) == Aspect.AIR) {
                    return 1.0f;
                }
                if (ItemInfusedSeeds.getAspect(stack) == Aspect.FIRE) {
                    return 2.0f;
                }
                if (ItemInfusedSeeds.getAspect(stack) == Aspect.WATER) {
                    return 3.0f;
                }
                if (ItemInfusedSeeds.getAspect(stack) == Aspect.EARTH) {
                    return 4.0f;
                }
                if (ItemInfusedSeeds.getAspect(stack) == Aspect.ENTROPY) {
                    return 5.0f;
                }
                if (ItemInfusedSeeds.getAspect(stack) == Aspect.ORDER) {
                    return 6.0f;
                }
                return 0.0f;
            }
        });
    }

    public static Aspect getAspect(ItemStack stack) {
        AspectList aspectList = new AspectList();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        aspectList.readFromNBT(stack.func_77978_p().func_74775_l(NBT_MAIN_ASPECT));
        return aspectList.size() == 0 ? null : aspectList.getAspects()[0];
    }

    public static void setAspect(ItemStack stack, Aspect aspect) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        AspectList aspectList = new AspectList().add(aspect, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        aspectList.writeToNBT(nbt);
        stack.func_77978_p().func_74782_a(NBT_MAIN_ASPECT, (NBTBase)nbt);
        ModItems.infused_seeds.setAspects(stack, new AspectList().add(aspectList.getAspects()[0], 2));
    }

    public static AspectList getAspectTendencies(ItemStack stack) {
        AspectList aspectList = new AspectList();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        aspectList.readFromNBT(stack.func_77978_p().func_74775_l(NBT_ASPECT_TENDENCIES));
        return aspectList;
    }

    public static void setAspectTendencies(ItemStack stack, AspectList aspectList) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        aspectList.writeToNBT(nbt);
        stack.func_77978_p().func_74782_a(NBT_ASPECT_TENDENCIES, (NBTBase)nbt);
    }

    public static ItemStack getStackFromAspect(Aspect a) {
        ItemStack stack = new ItemStack((Item)ModItems.infused_seeds);
        ItemInfusedSeeds.setAspect(stack, a);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        AspectList aspectList;
        Aspect aspect = ItemInfusedSeeds.getAspect(stack);
        if (aspect != null) {
            tooltip.add(aspect.getName());
        }
        if ((aspectList = ItemInfusedSeeds.getAspectTendencies(stack)) != null && aspectList.getAspects() != null && aspectList.getAspects().length > 0) {
            for (Aspect a : aspectList.getAspects()) {
                tooltip.add(a.getName() + ": " + aspectList.getAmount(a));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Aspect primal : Aspect.getPrimalAspects()) {
                ItemStack itemStack = new ItemStack((Item)this);
                ItemInfusedSeeds.setAspect(itemStack, primal);
                ItemInfusedSeeds.setAspectTendencies(itemStack, new AspectList());
                items.add((Object)itemStack);
            }
        }
    }

    public void registerModels() {
        for (Aspect primal : Aspect.getPrimalAspects()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)BlockInfusedGrain.getNumberFromAspectForTexture(primal), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + primal.getTag().toLowerCase(), "inventory"));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockFarmland && player.func_175151_a(pos, facing, stack) && player.func_175151_a(pos.func_177984_a(), facing, stack)) {
            world.func_175656_a(pos, ModBlocks.infused_farmland.func_176223_P());
            world.func_175656_a(pos.func_177984_a(), ModBlocks.infused_grain.func_176223_P());
            BlockInfusedGrain.setAspect((IBlockAccess)world, pos.func_177984_a(), ItemInfusedSeeds.getAspect(stack));
            TileInfusedGrain tile = (TileInfusedGrain)world.func_175625_s(pos.func_177984_a());
            if (tile != null) {
                tile.primalTendencies = ItemInfusedSeeds.getAspectTendencies(stack);
            }
            stack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public AspectList getAspects(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            AspectList aspects = new AspectList();
            aspects.readFromNBT(itemstack.func_77978_p());
            return aspects.size() > 0 ? aspects : null;
        }
        return null;
    }

    public void setAspects(ItemStack itemstack, AspectList aspects) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        aspects.writeToNBT(itemstack.func_77978_p());
    }

    public boolean ignoreContainedAspects() {
        return false;
    }
}

