/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items.Kami;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBlockTalisman
extends TTItem
implements IBauble {
    @Deprecated
    private static final String TAG_BLOCK_ID = "blockID";
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_META = "blockMeta";
    private static final String TAG_BLOCK_COUNT = "blockCount";
    private static int ticks;
    private static int count;
    private static String customString;
    private static final int maxTicks = 30;

    public ItemBlockTalisman() {
        super("block_talisman");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (stack.func_77960_j() == 1) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    private static void setCount(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_BLOCK_COUNT, count);
    }

    public static int remove(ItemStack stack, int count) {
        int current = ItemBlockTalisman.getBlockCount(stack);
        ItemBlockTalisman.setCount(stack, Math.max(current - count, 0));
        return Math.min(current, count);
    }

    @Deprecated
    public static int getBlockID(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_ID, 0);
    }

    public static String getBlockName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
    }

    public static Block getBlock(ItemStack stack) {
        Block block = Block.func_149684_b((String)ItemBlockTalisman.getBlockName(stack));
        if (block == Blocks.field_150350_a) {
            block = Block.func_149729_e((int)ItemBlockTalisman.getBlockID(stack));
        }
        return block;
    }

    public static int getBlockMeta(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_META, 0);
    }

    public static int getBlockCount(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_COUNT, 0);
    }

    public ActionResult<ItemStack> func_77659_a(World par2World, EntityPlayer par3EntityPlayer, @Nonnull EnumHand hand) {
        ItemStack par1ItemStack = par3EntityPlayer.func_184586_b(hand);
        if ((ItemBlockTalisman.getBlock(par1ItemStack) != Blocks.field_150350_a || ItemBlockTalisman.getBlockID(par1ItemStack) != 0) && par3EntityPlayer.func_70093_af()) {
            int dmg = par1ItemStack.func_77952_i();
            par1ItemStack.func_77964_b(~dmg & 1);
            par3EntityPlayer.func_184185_a(SoundEvents.field_187604_bf, 0.3f, 0.1f);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)par1ItemStack);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (Item.func_150898_a((Block)state.func_177230_c()) != Items.field_190931_a && this.setBlock(stack, state.func_177230_c(), state.func_177230_c().func_176201_c(state))) {
            return EnumActionResult.SUCCESS;
        }
        Block bBlock = ItemBlockTalisman.getBlock(stack);
        int bmeta = ItemBlockTalisman.getBlockMeta(stack);
        if (bBlock == null) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            if (!world.field_72995_K) {
                IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
                ItemStack toAdd = new ItemStack(bBlock, 1, bmeta);
                int maxSize = toAdd.func_77976_d();
                toAdd.func_190920_e(ItemBlockTalisman.remove(stack, maxSize));
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)toAdd, (boolean)false);
                if (!remainder.func_190926_b()) {
                    this.add(stack, remainder.func_190916_E());
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (player.field_71075_bZ.field_75098_d || ItemBlockTalisman.getBlockCount(stack) > 0) {
            ItemStack toUse = new ItemStack(bBlock, 1, bmeta);
            ItemStack saveHeldItem = player.func_184586_b(hand);
            player.func_184611_a(hand, toUse);
            EnumActionResult result = Item.func_150898_a((Block)bBlock).func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
            player.func_184611_a(hand, saveHeldItem);
            if (result == EnumActionResult.SUCCESS) {
                ItemBlockTalisman.remove(stack, 1);
                ItemBlockTalisman.set(toUse, ItemBlockTalisman.getBlockCount(stack));
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public static void set(ItemStack stack, String str) {
        ItemBlockTalisman.set(stack, 0, str);
    }

    public static void set(ItemStack stack, int count) {
        ItemBlockTalisman.set(stack, count, null);
    }

    public static void set(ItemStack stack, int count, String str) {
        stack = ItemStack.field_190927_a;
        ItemBlockTalisman.count = count;
        customString = str;
        ticks = stack.func_190926_b() ? 0 : 30;
    }

    private boolean setBlock(ItemStack stack, Block block, int meta) {
        if (ItemBlockTalisman.getBlock(stack) == Blocks.field_150350_a || ItemBlockTalisman.getBlockCount(stack) == 0) {
            ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, block.getRegistryName().toString());
            ItemNBTHelper.setInt(stack, TAG_BLOCK_META, meta);
            return true;
        }
        return false;
    }

    private void add(ItemStack stack, int count) {
        int current = ItemBlockTalisman.getBlockCount(stack);
        ItemBlockTalisman.setCount(stack, current + count);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        Block block = ItemBlockTalisman.getBlock(par1ItemStack);
        if (block != null && block != Blocks.field_150350_a) {
            int count = ItemBlockTalisman.getBlockCount(par1ItemStack);
            stacks.add(I18n.func_135052_a((String)(new ItemStack(block, 1, ItemBlockTalisman.getBlockMeta(par1ItemStack)).func_77977_a() + ".name"), (Object[])new Object[0]) + " (x" + count + ")");
        }
        if (par1ItemStack.func_77952_i() == 1) {
            stacks.add(I18n.func_135052_a((String)"ttmisc.active", (Object[])new Object[0]));
        } else {
            stacks.add(I18n.func_135052_a((String)"ttmisc.inactive", (Object[])new Object[0]));
        }
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase entity) {
        Block block = ItemBlockTalisman.getBlock(itemstack);
        if (!entity.field_70170_p.field_72995_K && itemstack.func_77952_i() == 1 && block != null && entity instanceof EntityPlayer) {
            int i;
            EntityPlayer player = (EntityPlayer)entity;
            int meta = ItemBlockTalisman.getBlockMeta(itemstack);
            int highest = -1;
            int[] counts = new int[player.field_71071_by.func_70302_i_() - player.field_71071_by.field_70460_b.size()];
            for (i = 0; i < counts.length; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || Item.func_150898_a((Block)block) != stack.func_77973_b() || stack.func_77952_i() != meta) continue;
                counts[i] = stack.func_190916_E();
                highest = highest == -1 ? i : (counts[i] > counts[highest] && highest > 8 ? i : highest);
            }
            if (highest != -1) {
                for (i = 0; i < counts.length; ++i) {
                    int count = counts[i];
                    if (i == highest || count == 0) continue;
                    this.add(itemstack, count);
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

