/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.misc;

import com.nekokittygames.thaumictinkerer.common.items.Kami.ItemKamiArmor;
import com.nekokittygames.thaumictinkerer.common.items.Kami.Tools.IAdvancedTool;
import com.nekokittygames.thaumictinkerer.common.items.Kami.Tools.IchoriumPickAdv;
import com.nekokittygames.thaumictinkerer.common.items.Kami.Tools.ToolHandler;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="thaumictinkerer")
public class LivingEvents {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        NBTTagCompound nbt = e.player.getEntityData();
        if (nbt.func_74767_n("can_fly")) {
            e.player.field_71075_bZ.field_75101_c = true;
            nbt.func_74757_a("can_fly", false);
        } else if (nbt.func_74764_b("can_fly")) {
            if (!e.player.field_71075_bZ.field_75098_d && !e.player.func_175149_v()) {
                e.player.field_71075_bZ.field_75101_c = false;
                e.player.field_71075_bZ.field_75100_b = false;
            }
            nbt.func_82580_o("can_fly");
        }
    }

    @SubscribeEvent
    public static void playerJumps(LivingEvent.LivingJumpEvent event) {
        ItemStack stack = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET);
        if (event.getEntity() instanceof EntityPlayer && stack.func_77973_b() instanceof ItemKamiArmor && stack.func_77952_i() != 1) {
            event.getEntityLiving().field_70181_x += 0.3;
        }
    }

    @SubscribeEvent
    public static void fall(LivingFallEvent e) {
        ItemStack boots = e.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET);
        if (!boots.func_190926_b() && boots.func_77973_b() instanceof ItemKamiArmor && boots.func_77952_i() != 1) {
            e.setDamageMultiplier(0.0f);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getHand() == EnumHand.MAIN_HAND) {
            ItemStack stack = event.getEntityPlayer().func_184614_ca();
            if (event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c().equals(Blocks.field_150357_h) && stack != null && stack.func_77973_b() instanceof IchoriumPickAdv) {
                stack.func_77973_b().onBlockStartBreak(stack, event.getPos(), event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    public static void Interact(PlayerInteractEvent event) {
        if (event.getEntityPlayer().field_71071_by.func_70431_c(new ItemStack((Item)ModItems.proto_clay))) {
            EntityPlayer par3Entity;
            EntityPlayer player = par3Entity = event.getEntityPlayer();
            ItemStack currentStack = player.field_71071_by.func_70448_g();
            if (currentStack == ItemStack.field_190927_a || !(currentStack.func_77973_b() instanceof IAdvancedTool)) {
                return;
            }
            IAdvancedTool tool = (IAdvancedTool)currentStack.func_77973_b();
            RayTraceResult pos = ToolHandler.raytraceFromEntity(par3Entity.field_70170_p, (Entity)par3Entity, true, 4.5);
            String typeToFind = "";
            if (player.field_82175_bq && pos != null) {
                IBlockState state = par3Entity.field_70170_p.func_180495_p(pos.func_178782_a());
                Material mat = state.func_185904_a();
                if (ToolHandler.isRightMaterial(mat, ToolHandler.materialsShovel)) {
                    typeToFind = "shovel";
                }
                if (ToolHandler.isRightMaterial(mat, ToolHandler.materialsPick)) {
                    typeToFind = "pick";
                }
                if (ToolHandler.isRightMaterial(mat, ToolHandler.materialsAxe)) {
                    typeToFind = "axe";
                }
            }
            if (tool.getType().equals(typeToFind) || typeToFind.isEmpty()) {
                return;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                IAdvancedTool toolInSlot;
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
                if (!(stackInSlot.func_77973_b() instanceof IAdvancedTool) || stackInSlot == currentStack || !(toolInSlot = (IAdvancedTool)stackInSlot.func_77973_b()).getType().equals(typeToFind)) continue;
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stackInSlot);
                player.field_71071_by.func_70299_a(i, currentStack);
                break;
            }
            event.setCanceled(true);
        }
    }
}

