/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.packets;

import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityEnchanter;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStartEnchant
implements IMessage {
    private BlockPos pos;
    private UUID playerID;

    public PacketStartEnchant() {
    }

    public PacketStartEnchant(TileEntityEnchanter enchanter, EntityPlayer player) {
        this.pos = enchanter.func_174877_v();
        this.playerID = player.func_110124_au();
    }

    public PacketStartEnchant(BlockPos pos, EntityPlayer player) {
        this.pos = pos;
        this.playerID = player.func_110124_au();
    }

    public UUID getPlayerID() {
        return this.playerID;
    }

    public void setPlayerID(UUID playerID) {
        this.playerID = playerID;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = BlockPos.func_177969_a((long)byteBuf.readLong());
        this.playerID = new UUID(byteBuf.readLong(), byteBuf.readLong());
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeLong(this.pos.func_177986_g());
        byteBuf.writeLong(this.playerID.getMostSignificantBits());
        byteBuf.writeLong(this.playerID.getLeastSignificantBits());
    }

    public static class Handler
    implements IMessageHandler<PacketStartEnchant, IMessage> {
        public IMessage onMessage(PacketStartEnchant packetAddEnchant, MessageContext messageContext) {
            FMLCommonHandler.instance().getWorldThread(messageContext.netHandler).func_152344_a(() -> this.handle(packetAddEnchant, messageContext));
            return null;
        }

        private void handle(PacketStartEnchant packetAddEnchant, MessageContext ctx) {
            TileEntity te;
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            World world = playerEntity.func_130014_f_();
            if (world.func_175667_e(packetAddEnchant.getPos()) && (te = world.func_175625_s(packetAddEnchant.getPos())) instanceof TileEntityEnchanter) {
                TileEntityEnchanter enchanter = (TileEntityEnchanter)te;
                EntityPlayer player = world.func_152378_a(packetAddEnchant.playerID);
                enchanter.setCheckSurroundings(true);
                if (enchanter.checkLocation()) {
                    if (player != null) {
                        if (!enchanter.playerHasIngredients(enchanter.getEnchantmentCost(), player)) {
                            return;
                        }
                        enchanter.takeIngredients(enchanter.getEnchantmentCost(), player);
                    }
                    enchanter.setWorking(true);
                } else if (player != null) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("thaumictinkerer.enchanter.badmb", new Object[0]));
                }
            }
        }
    }
}

