/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.common.misc.SingleItemStackHandler;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityThaumicTinkerer;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHopper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.blocks.essentia.BlockJarItem;
import thaumcraft.common.tiles.essentia.TileJarFillable;

public class TileEntityFunnel
extends TileEntityThaumicTinkerer
implements IAspectContainer,
ITickable {
    private int speed = 1;
    private SingleItemStackHandler inventory = new SingleItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityFunnel.this.sendUpdates();
        }

        public boolean isItemValidForSlot(int index, ItemStack stack) {
            return TileEntityFunnel.this.isItemValidForSlot(index, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof BlockJarItem;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
    }

    @Override
    public void readExtraNBT(NBTTagCompound nbttagcompound) {
        this.inventory.deserializeNBT(nbttagcompound.func_74775_l("inventory"));
    }

    @Override
    public boolean respondsToPulses() {
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != EnumFacing.DOWN) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != EnumFacing.DOWN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    private TileEntity getHopperFacing(BlockPos pos, int getBlockMetadata) {
        EnumFacing i = BlockHopper.func_176428_b((int)getBlockMetadata);
        return this.field_145850_b.func_175625_s(pos.func_177972_a(i));
    }

    public void func_73660_a() {
        IEssentiaContainerItem item;
        AspectList aspectList;
        if (this.inventory != null && this.inventory.getStackInSlot(0) != ItemStack.field_190927_a && ((IEssentiaContainerItem)this.inventory.getStackInSlot(0).func_77973_b()).getAspects(this.inventory.getStackInSlot(0)) != null && ((IEssentiaContainerItem)this.inventory.getStackInSlot(0).func_77973_b()).getAspects(this.inventory.getStackInSlot(0)).size() > 0 && !this.field_145850_b.field_72995_K && (aspectList = (item = (IEssentiaContainerItem)this.inventory.getStackInSlot(0).func_77973_b()).getAspects(this.inventory.getStackInSlot(0))) != null && aspectList.size() == 1) {
            TileEntity hoppered;
            Aspect aspect = aspectList.getAspects()[0];
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (tile != null && tile instanceof TileEntityHopper && (hoppered = this.getHopperFacing(tile.func_174877_v(), tile.func_145832_p())) instanceof TileJarFillable) {
                TileJarFillable jar = (TileJarFillable)hoppered;
                AspectList JarAspects = jar.getAspects();
                if ((jar.aspectFilter == null || jar.aspectFilter == aspect) && (JarAspects != null && JarAspects.size() == 0 || Objects.requireNonNull(JarAspects).getAspects()[0] == aspect)) {
                    int remain = jar.addToContainer(aspect, this.speed);
                    int amt = this.speed - remain;
                    item.setAspects(this.inventory.getStackInSlot(0), aspectList.remove(aspect, amt));
                }
            }
        }
    }

    public AspectList getAspects() {
        if (this.inventory.getStackInSlot(0) != ItemStack.field_190927_a && ((IEssentiaContainerItem)this.inventory.getStackInSlot(0).func_77973_b()).getAspects(this.inventory.getStackInSlot(0)) != null && ((IEssentiaContainerItem)this.inventory.getStackInSlot(0).func_77973_b()).getAspects(this.inventory.getStackInSlot(0)).size() > 0) {
            return ((IEssentiaContainerItem)this.inventory.getStackInSlot(0).func_77973_b()).getAspects(this.inventory.getStackInSlot(0));
        }
        return null;
    }

    public void setAspects(AspectList aspectList) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return false;
    }

    public int addToContainer(Aspect aspect, int i) {
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return false;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        return false;
    }

    public int containerContains(Aspect aspect) {
        return 0;
    }
}

