/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.common.blocks.BlockMagnet;
import com.nekokittygames.thaumictinkerer.common.misc.MiscHelper;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityInventoryTinkerer;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.codechicken.lib.vec.Vector3;

public abstract class TileEntityMagnet
extends TileEntityInventoryTinkerer
implements ITickable {
    protected ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityMagnet.this.sendUpdates();
        }

        public boolean isItemValidForSlot(int index, ItemStack stack) {
            return TileEntityMagnet.this.func_94041_b(index, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public TileEntityMagnet() {
        super(1);
    }

    protected abstract <T extends Entity> Predicate selectedEntities();

    public BlockMagnet.MagnetPull GetMode() {
        return (BlockMagnet.MagnetPull)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockMagnet.POLE));
    }

    public void setMode(BlockMagnet.MagnetPull mode) {
        IBlockState current = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, current.func_177226_a(BlockMagnet.POLE, (Comparable)((Object)mode)));
    }

    public void func_73660_a() {
        int redstone = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            redstone = Math.max(redstone, this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir));
        }
        if (redstone > 0) {
            double x1 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double y1 = (double)this.field_174879_c.func_177956_o() + 0.5;
            double z1 = (double)this.field_174879_c.func_177952_p() + 0.5;
            BlockMagnet.MagnetPull mode = this.GetMode();
            int speedMod = mode == BlockMagnet.MagnetPull.PULL ? 1 : -1;
            double range = redstone >> 1;
            List entities = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(x1 - range, (double)this.field_174879_c.func_177956_o(), z1 - range, x1 + range, y1 + range, z1 + range), this.selectedEntities()::test);
            for (Entity entity : entities) {
                double x2 = entity.field_70165_t;
                double y2 = entity.field_70163_u;
                double z2 = entity.field_70161_v;
                float f = mode == BlockMagnet.MagnetPull.PULL ? (float)((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2)) : 1.1f;
                float distanceSqrd = f;
                if (!(distanceSqrd > 1.0f)) continue;
                MiscHelper.setEntityMotionFromVector(entity, new Vector3(x1, y1, z1), (float)speedMod * 0.25f);
                if (this.field_145850_b == null || !this.field_145850_b.field_72995_K || FXDispatcher.INSTANCE.getWorld() == null) continue;
                FXDispatcher.INSTANCE.sparkle((float)x2, (float)y2, (float)z2, mode == BlockMagnet.MagnetPull.PULL ? 0.0f : 1.0f, 0.0f, mode == BlockMagnet.MagnetPull.PULL ? 1.0f : 0.0f);
            }
        }
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound nbttagcompound) {
        super.writeExtraNBT(nbttagcompound);
        nbttagcompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
    }

    @Override
    public void readExtraNBT(NBTTagCompound nbttagcompound) {
        super.readExtraNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbttagcompound.func_74775_l("inventory"));
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    protected abstract boolean filterEntity(Entity var1);

    @Override
    public abstract boolean func_94041_b(int var1, ItemStack var2);

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() == newSate.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newSate);
    }
}

