/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.common.blocks.BlockInfusedGrain;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;

public class TileInfusedGrain
extends TileEntity
implements IAspectContainer,
ITickable {
    private static final String NBT_MAIN_ASPECT = "mainAspect";
    private static final String NBT_ASPECT_TENDENCIES = "aspectTendencies";
    public Aspect aspect;
    public AspectList primalTendencies = new AspectList();

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readCustomNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeCustomNBT(nbt);
        return nbt;
    }

    public void func_73660_a() {
        IBlockState state;
        int age;
        if (this.aspect == null) {
            this.aspect = Aspect.AIR;
        }
        if (this.primalTendencies == null) {
            this.primalTendencies = new AspectList();
            this.primalTendencies.merge(this.aspect, 1);
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_175671_l(this.field_174879_c.func_177984_a()) >= 9 && (age = ((Integer)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((IProperty)BlockInfusedGrain.AGE)).intValue()) < 7 && this.field_145850_b.field_73012_v.nextInt((2510 - (int)Math.pow(this.primalTendencies.getAmount(Aspect.WATER), 2.0)) * 6) == 0) {
            this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)BlockInfusedGrain.AGE, (Comparable)Integer.valueOf(age + 1)), 3);
        }
        if (this.field_145850_b.field_73012_v.nextInt((2550 - (int)Math.pow(this.primalTendencies.getAmount(Aspect.AIR), 2.0)) * 10) == 0 && !this.aspect.isPrimal()) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos neighborPos = this.field_174879_c.func_177972_a(dir);
                TileEntity entity = this.field_145850_b.func_175625_s(neighborPos);
                if (!(entity instanceof TileInfusedGrain)) continue;
                TileInfusedGrain neighbor = (TileInfusedGrain)entity;
                if (neighbor.aspect.isPrimal()) {
                    if (this.primalTendencies.getAmount(neighbor.aspect) >= 5) continue;
                    this.primalTendencies.add(neighbor.aspect, 1);
                    this.reduceSaturatedAspects();
                    this.func_70296_d();
                    if (this.field_145850_b.field_72995_K) {
                        this.spawnParticles(neighborPos, neighbor.aspect);
                    }
                    return;
                }
                AspectList targetList = neighbor.primalTendencies;
                if (targetList.getAspects().length == 0 || targetList.getAspects()[0] == null) {
                    return;
                }
                Aspect exchangeAspect = targetList.getAspects()[this.field_145850_b.field_73012_v.nextInt(targetList.getAspects().length)];
                if (targetList.getAmount(exchangeAspect) >= this.primalTendencies.getAmount(exchangeAspect)) {
                    this.primalTendencies.add(exchangeAspect, 1);
                    targetList.reduce(exchangeAspect, 1);
                    this.reduceSaturatedAspects();
                    if (this.field_145850_b.field_72995_K) {
                        this.spawnParticles(neighborPos, exchangeAspect);
                    }
                    this.func_70296_d();
                }
                return;
            }
        }
    }

    private void spawnParticles(BlockPos neighborPos, Aspect aspect) {
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void reduceSaturatedAspects() {
        int sum = this.primalTendencies.aspects.values().stream().mapToInt(Integer::intValue).sum();
        if (sum > 50) {
            Aspect[] aspects;
            Random rand = new Random();
            for (int toRemove = sum - 50; toRemove > 0 && (aspects = this.primalTendencies.getAspects()).length != 0; --toRemove) {
                Aspect target = aspects[rand.nextInt(aspects.length)];
                this.primalTendencies.remove(target, 1);
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt) {
        NBTTagCompound aspectCompound = new NBTTagCompound();
        if (this.aspect != null) {
            new AspectList().add(this.aspect, 1).writeToNBT(aspectCompound);
        }
        nbt.func_74782_a(NBT_MAIN_ASPECT, (NBTBase)aspectCompound);
        NBTTagCompound tendencyCompound = new NBTTagCompound();
        this.primalTendencies.writeToNBT(tendencyCompound);
        nbt.func_74782_a(NBT_ASPECT_TENDENCIES, (NBTBase)tendencyCompound);
    }

    public void readCustomNBT(NBTTagCompound nbt) {
        AspectList aspectList = new AspectList();
        aspectList.readFromNBT(nbt.func_74775_l(NBT_MAIN_ASPECT));
        this.aspect = aspectList.getAspects().length > 0 ? aspectList.getAspects()[0] : null;
        this.primalTendencies = new AspectList();
        this.primalTendencies.readFromNBT(nbt.func_74775_l(NBT_ASPECT_TENDENCIES));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeCustomNBT(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, -999, compound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        this.writeCustomNBT(compound);
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound compound) {
        super.handleUpdateTag(compound);
        this.readCustomNBT(compound);
    }

    public AspectList getAspects() {
        return this.aspect != null ? new AspectList().add(this.aspect, 1) : null;
    }

    public void setAspects(AspectList paramAspectList) {
    }

    public boolean doesContainerAccept(Aspect paramAspect) {
        return false;
    }

    public int addToContainer(Aspect paramAspect, int paramInt) {
        return 0;
    }

    public boolean takeFromContainer(Aspect paramAspect, int paramInt) {
        return false;
    }

    public boolean takeFromContainer(AspectList paramAspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect paramAspect, int paramInt) {
        return false;
    }

    public boolean doesContainerContain(AspectList paramAspectList) {
        return false;
    }

    public int containerContains(Aspect paramAspect) {
        return 0;
    }
}

