/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity.transvector;

import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityCamoflage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public abstract class TileEntityTransvector
extends TileEntityCamoflage
implements ITickable {
    private static final String TAG_X_TARGET = "xt";
    private static final String TAG_Y_TARGET = "yt";
    private static final String TAG_Z_TARGET = "zt";
    private static final String TAG_CHEATY_MODE = "cheatyMode";
    private BlockPos tilePos;
    private boolean cheaty;

    @Override
    public void readExtraNBT(NBTTagCompound compound) {
        super.readExtraNBT(compound);
        if (compound.func_74764_b(TAG_X_TARGET)) {
            int x = compound.func_74762_e(TAG_X_TARGET);
            int y = compound.func_74762_e(TAG_Y_TARGET);
            int z = compound.func_74762_e(TAG_Z_TARGET);
            this.tilePos = new BlockPos(x, y, z);
            this.cheaty = compound.func_74767_n(TAG_CHEATY_MODE);
        }
    }

    @Override
    public void writeExtraNBT(NBTTagCompound compound) {
        super.writeExtraNBT(compound);
        if (this.tilePos != null) {
            compound.func_74768_a(TAG_X_TARGET, this.tilePos.func_177958_n());
            compound.func_74768_a(TAG_Y_TARGET, this.tilePos.func_177956_o());
            compound.func_74768_a(TAG_Z_TARGET, this.tilePos.func_177952_p());
            compound.func_74757_a(TAG_CHEATY_MODE, this.cheaty);
        }
    }

    public BlockPos getTilePos() {
        return this.tilePos;
    }

    public boolean setTilePos(BlockPos tilePos) {
        TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
        if (this.checkTile(tilePos, tile)) {
            return false;
        }
        this.tilePos = tilePos;
        return true;
    }

    public boolean checkTile(BlockPos tilePos, TileEntity tile) {
        return tile == null && this.tileRequiredAtLink() || tilePos.func_177951_i((Vec3i)this.func_174877_v()) > (double)this.getMaxDistance();
    }

    public boolean isCheaty() {
        return this.cheaty;
    }

    public void setCheaty(boolean cheaty) {
        this.cheaty = cheaty;
    }

    public final TileEntity getTile() {
        if (this.tilePos == null) {
            return null;
        }
        if (this.field_145850_b.func_175623_d(this.tilePos)) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.tilePos);
        if (this.checkTile(this.tilePos, tile)) {
            this.tilePos = null;
            return null;
        }
        return tile;
    }

    public void func_73660_a() {
    }

    public abstract int getMaxDistance();

    private boolean tileRequiredAtLink() {
        return !this.cheaty;
    }
}

