/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thefloydman.moremystcraft.tileentity.TileEntitySingleItem;
import thefloydman.moremystcraft.util.JourneyUtils;
import thefloydman.moremystcraft.util.MoreMystcraftCreativeTabs;

public class BlockJourneyBase
extends BlockHorizontal
implements ITileEntityProvider {
    public static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
    public static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
    public static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public final JourneyUtils.PatternType PATTERN_TYPE;

    public BlockJourneyBase(JourneyUtils.PatternType type, Material material) {
        super(material);
        this.PATTERN_TYPE = type;
        this.func_149711_c(0.5f);
        this.func_149647_a(MoreMystcraftCreativeTabs.MORE_MYSTCRAFT);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (((EnumFacing)state.func_177228_b().get((Object)field_185512_D)).func_176736_b()) {
            case 0: {
                return AABB_NORTH;
            }
            case 1: {
                return AABB_EAST;
            }
            case 2: {
                return AABB_SOUTH;
            }
            case 3: {
                return AABB_WEST;
            }
        }
        return AABB_NORTH;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        boolean mod = !world.func_180495_p(pos.func_177972_a(side.func_176734_d())).func_193401_d((IBlockAccess)world, pos, null).equals((Object)BlockFaceShape.UNDEFINED) && !side.equals((Object)EnumFacing.UP) && !side.equals((Object)EnumFacing.DOWN);
        boolean vanilla = super.func_176198_a(world, pos, side);
        return mod && vanilla;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        boolean mod = world.func_175623_d(pos) || world.func_180495_p(pos).func_185904_a().equals(Material.field_151597_y) || world.func_180495_p(pos).func_185904_a().equals(Material.field_151577_b) && !world.func_180495_p(pos).func_193401_d((IBlockAccess)world, pos, null).equals((Object)BlockFaceShape.UNDEFINED);
        boolean vanilla = super.func_176196_c(world, pos);
        return mod && vanilla;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_180495_p(fromPos).func_185904_a().func_76224_d()) {
            this.func_180663_b(world, pos, state);
            world.func_175698_g(pos);
        } else if (((Comparable)state.func_177228_b().get((Object)field_185512_D)).equals(EnumFacing.NORTH)) {
            if (!world.func_180495_p(pos.func_177968_d()).func_185904_a().func_76220_a()) {
                this.func_180663_b(world, pos, state);
                world.func_175698_g(pos);
            }
        } else if (((Comparable)state.func_177228_b().get((Object)field_185512_D)).equals(EnumFacing.EAST)) {
            if (!world.func_180495_p(pos.func_177976_e()).func_185904_a().func_76220_a()) {
                this.func_180663_b(world, pos, state);
                world.func_175698_g(pos);
            }
        } else if (((Comparable)state.func_177228_b().get((Object)field_185512_D)).equals(EnumFacing.SOUTH)) {
            if (!world.func_180495_p(pos.func_177978_c()).func_185904_a().func_76220_a()) {
                this.func_180663_b(world, pos, state);
                world.func_175698_g(pos);
            }
        } else if (((Comparable)state.func_177228_b().get((Object)field_185512_D)).equals(EnumFacing.WEST) && !world.func_180495_p(pos.func_177974_f()).func_185904_a().func_76220_a()) {
            this.func_180663_b(world, pos, state);
            world.func_175698_g(pos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
        }
        this.notifyNeighbors(world, pos, state);
        super.func_180663_b(world, pos.func_177976_e(), state);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySingleItem();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected void notifyNeighbors(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177228_b().get((Object)field_185512_D);
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177972_a(facing.func_176734_d()), (Block)this, false);
    }
}

