/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.block;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thefloydman.moremystcraft.block.BlockJourneyBase;
import thefloydman.moremystcraft.capability.journeyclothscollected.CapabilityJourneyClothsCollected;
import thefloydman.moremystcraft.capability.journeyclothscollected.ProviderCapabilityJourneyClothsCollected;
import thefloydman.moremystcraft.capability.journeyhub.ICapabilityHub;
import thefloydman.moremystcraft.capability.journeyhub.ProviderCapabilityHub;
import thefloydman.moremystcraft.capability.uuid.ICapabilityUUID;
import thefloydman.moremystcraft.capability.uuid.ProviderCapabilityUUID;
import thefloydman.moremystcraft.data.worldsaveddata.MoreMystcraftSavedDataPerSave;
import thefloydman.moremystcraft.item.ItemJourneyHub;
import thefloydman.moremystcraft.network.MoreMystcraftPacketHandler;
import thefloydman.moremystcraft.tileentity.TileEntityJourney;
import thefloydman.moremystcraft.tileentity.TileEntitySingleItem;
import thefloydman.moremystcraft.util.JourneyUtils;
import thefloydman.moremystcraft.util.Reference;

public class BlockJourneyCloth
extends BlockJourneyBase {
    public static final PropertyBool ANIMATED = PropertyBool.func_177716_a((String)"animated");

    public BlockJourneyCloth(JourneyUtils.PatternType type) {
        super(type, Material.field_151580_n);
        this.func_149663_c("moremystcraft.journey_cloth_" + type.name().toLowerCase());
        this.setRegistryName(Reference.forMoreMystcraft("journey_cloth_" + type.name().toLowerCase()));
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ANIMATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, ANIMATED});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntitySingleItem) {
            UUID uuid;
            ICapabilityUUID capStack = (ICapabilityUUID)((TileEntitySingleItem)tileEntity).getItem().getCapability(ProviderCapabilityUUID.UUID, facing);
            if (capStack.getUUID() == null) {
                capStack.setUUID(UUID.randomUUID());
            }
            if ((uuid = capStack.getUUID()) != null) {
                if (player.func_184586_b(hand).func_77973_b() instanceof ItemJourneyHub) {
                    ICapabilityHub capHub = (ICapabilityHub)player.func_184586_b(hand).getCapability(ProviderCapabilityHub.HUB, facing);
                    if (!player.func_70093_af()) {
                        if (capHub.getUUIDs().size() < 15) {
                            capHub.addUUID(uuid);
                            MoreMystcraftPacketHandler.sendTranslatedMessage((EntityPlayerMP)player, Reference.Message.CLOTH_ADDED_TO_HUB.key, Reference.MessageType.STATUS.ordinal(), "none");
                        } else {
                            MoreMystcraftPacketHandler.sendTranslatedMessage((EntityPlayerMP)player, Reference.Message.HUB_FULL.key, Reference.MessageType.STATUS.ordinal(), "none");
                        }
                    } else {
                        capHub.removeCloth(uuid);
                        MoreMystcraftPacketHandler.sendTranslatedMessage((EntityPlayerMP)player, Reference.Message.CLOTH_REMOVED_FROM_HUB.key, Reference.MessageType.STATUS.ordinal(), "none");
                    }
                } else {
                    CapabilityJourneyClothsCollected capPlayer = (CapabilityJourneyClothsCollected)player.getCapability(ProviderCapabilityJourneyClothsCollected.JOURNEY_CLOTH, facing);
                    MoreMystcraftSavedDataPerSave data = MoreMystcraftSavedDataPerSave.get(world);
                    if (player.func_70093_af()) {
                        capPlayer.removeCloth(uuid);
                        data.deactivateJourneyCloth(uuid, player.func_110124_au());
                        MoreMystcraftPacketHandler.sendTranslatedMessage((EntityPlayerMP)player, Reference.Message.CLOTH_DEACTIVATED.key, Reference.MessageType.STATUS.ordinal(), "none");
                    } else if (!capPlayer.getActivatedCloths().contains(uuid)) {
                        capPlayer.addCloth(uuid);
                        data.activateJourneyCloth(uuid, player.func_110124_au());
                        MoreMystcraftPacketHandler.sendTranslatedMessage((EntityPlayerMP)player, Reference.Message.CLOTH_ACTIVATED.key, Reference.MessageType.STATUS.ordinal(), "none");
                        MoreMystcraftPacketHandler.renderJourneyActivation((EntityPlayerMP)player, pos);
                    }
                }
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntitySingleItem) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(1);
            TileEntitySingleItem clothEntity = (TileEntitySingleItem)tileEntity;
            clothEntity.setItem(newStack);
            ICapabilityUUID cap = (ICapabilityUUID)clothEntity.getItem().getCapability(ProviderCapabilityUUID.UUID, null);
            if (cap.getUUID() == null) {
                cap.setUUID(UUID.randomUUID());
            }
            MoreMystcraftSavedDataPerSave data = MoreMystcraftSavedDataPerSave.get(world);
            data.addJourneyCloth(cap.getUUID());
            data.setClothPos(cap.getUUID(), world.field_73011_w.getDimension(), pos);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntitySingleItem) {
                TileEntitySingleItem clothEntity = (TileEntitySingleItem)te;
                ICapabilityUUID cap = (ICapabilityUUID)clothEntity.getItem().getCapability(ProviderCapabilityUUID.UUID, null);
                MoreMystcraftSavedDataPerSave data = MoreMystcraftSavedDataPerSave.get(world);
                data.removeClothPos(cap.getUUID());
            }
            if (te instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityJourney(JourneyUtils.BlockType.CLOTH);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

