/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.capability.journeyhub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thefloydman.moremystcraft.capability.journeyhub.ICapabilityHub;
import thefloydman.moremystcraft.data.worldsaveddata.MoreMystcraftSavedDataPerSave;

public class CapabilityHub
implements ICapabilityHub {
    protected List<UUID> idList = new ArrayList<UUID>();
    protected int timeLimit = 100;
    protected boolean perPlayer = false;
    protected UUID lastActivatedBy = null;
    Map<UUID, Integer> clothDimensions = new HashMap<UUID, Integer>();
    Map<UUID, BlockPos> clothPositions = new HashMap<UUID, BlockPos>();
    protected UUID owner = UUID.randomUUID();

    public void addCloth(UUID uuid, int dim, BlockPos pos) {
        this.addUUID(uuid);
        this.setClothDimension(uuid, dim);
        this.setClothPos(uuid, pos);
    }

    @Override
    public void removeCloth(UUID uuid) {
        while (this.idList.contains(uuid)) {
            this.idList.remove(uuid);
        }
        while (this.clothDimensions.containsKey(uuid)) {
            this.clothDimensions.remove(uuid);
        }
        while (this.clothPositions.containsKey(uuid)) {
            this.clothPositions.remove(uuid);
        }
    }

    public void clearAllCloths() {
        this.idList = new ArrayList<UUID>();
        this.clothDimensions = new HashMap<UUID, Integer>();
        this.clothPositions = new HashMap<UUID, BlockPos>();
    }

    @Override
    public void addUUID(UUID uuid) {
        if (!this.idList.contains(uuid)) {
            this.idList.add(uuid);
        }
    }

    @Override
    public UUID getUUID(int index) {
        if (index >= this.idList.size()) {
            return null;
        }
        return this.idList.get(index);
    }

    @Override
    public List<UUID> getUUIDs() {
        return this.idList;
    }

    @Override
    public void clearUUIDs() {
        this.idList = new ArrayList<UUID>();
    }

    @Override
    public void setTimeLimit(int ticks) {
        this.timeLimit = ticks;
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setPerPlayer(boolean bool) {
        this.perPlayer = bool;
    }

    @Override
    public boolean getPerPlayer() {
        return this.perPlayer;
    }

    @Override
    public UUID getLastActivatedBy() {
        return this.lastActivatedBy;
    }

    @Override
    public void setLastActivatedBy(UUID uuid) {
        this.lastActivatedBy = uuid;
    }

    @Override
    public int getClothDimension(UUID uuid) {
        if (this.clothDimensions.containsKey(uuid)) {
            return this.clothDimensions.get(uuid);
        }
        return 0;
    }

    @Override
    public void setClothDimension(UUID uuid, int dim) {
        this.clothDimensions.put(uuid, dim);
    }

    @Override
    public BlockPos getClothPos(UUID uuid) {
        if (this.clothPositions.containsKey(uuid)) {
            return this.clothPositions.get(uuid);
        }
        return new BlockPos(0, 0, 0);
    }

    @Override
    public void setClothPos(UUID uuid, BlockPos pos) {
        this.clothPositions.put(uuid, pos);
    }

    @Override
    public void updateClothInfo(World world) {
        MoreMystcraftSavedDataPerSave data = MoreMystcraftSavedDataPerSave.get(world);
        NBTTagList clothList = data.getAllJourneyClothInfo();
        for (NBTBase base : clothList) {
            UUID uuid;
            NBTTagCompound cmp = (NBTTagCompound)base;
            if (!cmp.func_74764_b("uuid") || !this.idList.contains(uuid = NBTUtil.func_186860_b((NBTTagCompound)cmp.func_74775_l("uuid")))) continue;
            if (cmp.func_74764_b("dim")) {
                this.setClothDimension(uuid, cmp.func_74762_e("dim"));
            }
            if (!cmp.func_74764_b("pos")) continue;
            this.setClothPos(uuid, NBTUtil.func_186861_c((NBTTagCompound)cmp.func_74775_l("pos")));
        }
    }

    @Override
    public void setOwner(UUID uuid) {
        this.owner = uuid;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }
}

