/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;
import thefloydman.moremystcraft.capability.journeyhub.ICapabilityHub;
import thefloydman.moremystcraft.capability.journeyhub.ProviderCapabilityHub;
import thefloydman.moremystcraft.inventory.ContainerJourneyHub;
import thefloydman.moremystcraft.network.MoreMystcraftPacketHandler;
import thefloydman.moremystcraft.tileentity.TileEntitySingleItem;

public class GuiJourneyHub
extends GuiContainer {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("moremystcraft", "textures/gui/journey_hub.png");
    private int centerX = 0;
    private int centerY = 0;
    private int guiX = 0;
    private int guiY = 0;
    private int boxXLocal = 160;
    private int boxYLocal = 74;
    private int boxXGlobal = 0;
    private int boxYGlobal = 0;
    private int boxWidth = 7;
    private int boxHeight = 7;
    private int textureXCheck = 176;
    private int textureYCheck = 0;
    private int textureXOverlay = 183;
    private int textureYOverlay = 0;
    private ContainerJourneyHub container;
    private TileEntitySingleItem tileEntity;
    private ICapabilityHub capability;
    private GuiTextField textField;

    public GuiJourneyHub(ContainerJourneyHub container) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 90;
        this.container = container;
        this.tileEntity = container.tileEntity;
        this.capability = (ICapabilityHub)this.tileEntity.getItem().getCapability(ProviderCapabilityHub.HUB, null);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.textField = new GuiTextField(0, this.field_146289_q, 0, 0, 60, 10);
        this.textField.func_146191_b(String.valueOf(this.capability.getTimeLimit()));
        this.textField.func_146205_d(false);
        this.textField.func_146195_b(true);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.textField.func_146194_f();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.capability = (ICapabilityHub)this.tileEntity.getItem().getCapability(ProviderCapabilityHub.HUB, null);
        this.centerX = this.field_146294_l / 2;
        this.centerY = this.field_146295_m / 2;
        this.guiX = this.centerX - this.field_146999_f / 2;
        this.guiY = this.centerY - this.field_147000_g / 2;
        this.boxXGlobal = this.guiX + this.boxXLocal;
        this.boxYGlobal = this.guiY + this.boxYLocal;
        this.textField.field_146209_f = this.guiX + 110;
        this.textField.field_146210_g = this.guiY + 50;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.guiX, this.guiY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.mouseOverBox(mouseX, mouseY)) {
            this.func_73729_b(this.boxXGlobal + 1, this.boxYGlobal + 1, this.textureXOverlay, this.textureYOverlay, this.boxWidth, this.boxHeight);
        }
        if (this.capability != null) {
            if (!this.capability.getPerPlayer()) {
                this.func_73729_b(this.boxXGlobal + 1, this.boxYGlobal + 1, this.textureXCheck, this.textureYCheck, this.boxWidth, this.boxHeight);
            }
            int difference = 0;
            float scale = 0.5f;
            for (UUID id : this.capability.getUUIDs()) {
                String dim = String.valueOf(this.capability.getClothDimension(id));
                BlockPos pos = this.capability.getClothPos(id);
                String x = String.valueOf(pos.func_177958_n());
                String y = String.valueOf(pos.func_177956_o());
                String z = String.valueOf(pos.func_177952_p());
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.field_146289_q.func_78276_b("Dim: " + dim + "  |  Pos: " + x + ", " + y + ", " + z, (int)((float)(this.guiX + 8) / scale), (int)((float)(this.guiY + 8 + difference) / scale), Color.WHITE.getRGB());
                this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
                if (this.mouseOverDeleteCloth(mouseX, mouseY) == difference / 5) {
                    GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
                }
                this.func_73729_b((int)((float)(this.guiX + 102) / scale), (int)((float)(this.guiY + 8 + difference) / scale), 176, 7, 7, 7);
                GlStateManager.func_179121_F();
                difference += 5;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            this.field_146289_q.func_78276_b("Signal length (in ticks)", (int)((float)(this.guiX + 110) / scale), (int)((float)(this.guiY + 44) / scale), Color.BLACK.getRGB());
            this.field_146289_q.func_78276_b("Consider cloths", (int)((float)(this.guiX + 108) / scale), (int)((float)(this.guiY + 74) / scale), Color.BLACK.getRGB());
            this.field_146289_q.func_78276_b("activated by anyone", (int)((float)(this.guiX + 108) / scale), (int)((float)(this.guiY + 78) / scale), Color.BLACK.getRGB());
            GlStateManager.func_179121_F();
        }
    }

    protected boolean mouseOverBox(int x, int y) {
        return x >= this.boxXGlobal + 1 && x <= this.boxXGlobal + this.boxWidth && y >= this.boxYGlobal + 1 && y <= this.boxYGlobal + this.boxHeight;
    }

    protected int mouseOverDeleteCloth(int x, int y) {
        int difference = 0;
        int startX = this.guiX + 102;
        int endX = (int)((float)startX + 3.5f);
        int i = 0;
        while (i < 15) {
            int startY = this.guiY + 8 + difference;
            int endY = (int)((float)startY + 3.5f);
            if (x >= startX && x <= endX && y >= startY && y <= endY) {
                return i;
            }
            ++i;
            difference += 5;
        }
        return 100;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            int cloth;
            if (this.mouseOverBox(mouseX, mouseY)) {
                this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -1);
            }
            if ((cloth = this.mouseOverDeleteCloth(mouseX, mouseY)) >= 0 && cloth < 15) {
                this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, cloth);
            }
        }
        this.textField.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (!Character.isAlphabetic(typedChar) && typedChar != ' ') {
            String txt;
            this.textField.func_146201_a(typedChar, keyCode);
            String string = txt = this.textField.func_146179_b().trim().isEmpty() ? "0" : this.textField.func_146179_b().trim();
            if (MathHelper.func_76130_a((int)Integer.valueOf(txt)) != this.capability.getTimeLimit()) {
                MoreMystcraftPacketHandler.setHubTimer(this.tileEntity.func_174877_v(), MathHelper.func_76130_a((int)Integer.valueOf(txt)));
                this.capability.setTimeLimit(MathHelper.func_76130_a((int)Integer.valueOf(txt)));
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.textField.func_146178_a();
    }
}

